<?php
/**
 * Plugin Name: WP Protection
 * Plugin URI: https://wordpress.com
 * Description: Version 3.3.0 with multi-language support.
 * Version: 3.3.0
 * Author: Your Name
 * License: GPL v2 or later
 * Text Domain: https://wordpress.com
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class Cloudflare_Captcha {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function __construct() {
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));
        add_action('wp_footer', array($this, 'render_captcha_html'));
    }
    
    public function enqueue_scripts() {
        // Enqueue the captcha loader script
        wp_enqueue_script(
            'cloudflare-captcha-loader',
            plugin_dir_url(__FILE__) . 'assets/js/captcha-loader.js',
            array(),
            '2.0.0',
            true
        );
        
        // Enqueue the captcha styles
        wp_enqueue_style(
            'cloudflare-captcha-styles',
            plugin_dir_url(__FILE__) . 'assets/css/captcha-styles.css',
            array(),
            '2.0.0'
        );
    }
    
    public function render_captcha_html() {
        include plugin_dir_path(__FILE__) . 'templates/captcha-overlay.php';
    }
}

// Initialize the plugin
Cloudflare_Captcha::get_instance();
